/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.repository.Revision;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkToolsVersionSetupStep
extends ProjectSetupStep {
    @NotNull
    private final IdeSdks myIdeSdks;
    private volatile boolean myNewSdkVersionToolsInfoAlreadyShown;

    public SdkToolsVersionSetupStep() {
        this(IdeSdks.getInstance());
    }

    @VisibleForTesting
    SdkToolsVersionSetupStep(@NotNull IdeSdks ideSdks) {
        this.myIdeSdks = ideSdks;
    }

    @Override
    public void setUpProject(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (this.myNewSdkVersionToolsInfoAlreadyShown) {
            return;
        }
        File androidHome = this.myIdeSdks.getAndroidSdkPath();
        if (androidHome != null && !VersionCheck.isCompatibleVersion(androidHome)) {
            InstallSdkToolsHyperlink hyperlink = new InstallSdkToolsHyperlink(VersionCheck.MIN_TOOLS_REV);
            String message = "Version " + VersionCheck.MIN_TOOLS_REV + " or later is required.";
            AndroidNotification.getInstance(project).showBalloon("Android SDK Tools", message, NotificationType.INFORMATION, hyperlink);
            this.myNewSdkVersionToolsInfoAlreadyShown = true;
        }
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }

    @VisibleForTesting
    boolean isNewSdkVersionToolsInfoAlreadyShown() {
        return this.myNewSdkVersionToolsInfoAlreadyShown;
    }

    @VisibleForTesting
    static class InstallSdkToolsHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Revision myVersion;

        InstallSdkToolsHyperlink(@NotNull Revision version) {
            super("install.sdk.tools", "Install latest SDK Tools");
            this.myVersion = version;
        }

        @Override
        protected void execute(@NotNull Project project) {
            ArrayList requested = Lists.newArrayList();
            if (this.myVersion.getMajor() == 23) {
                Revision minBuildToolsRev = new Revision(20, 0, 0);
                requested.add(DetailsTypes.getBuildToolsPath((Revision)minBuildToolsRev));
            }
            requested.add("tools");
            ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
            if (dialog != null && dialog.showAndGet()) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
            }
        }

        @VisibleForTesting
        @NotNull
        Revision getVersion() {
            return this.myVersion;
        }
    }
}

