/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.ForcedPluginPreviewVersionUpgradeDialog;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedPluginPreviewVersionUpgradeStep
extends PluginVersionUpgradeStep {
    @Override
    public boolean checkAndPerformUpgrade(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        AndroidPluginGeneration pluginGeneration = pluginInfo.getPluginGeneration();
        GradleVersion recommended = GradleVersion.parse((String)pluginGeneration.getLatestKnownVersion());
        if (!ForcedPluginPreviewVersionUpgradeStep.shouldPreviewBeForcedToUpgradePluginVersion(recommended, pluginInfo.getPluginVersion())) {
            return false;
        }
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        syncState.syncEnded();
        boolean userAcceptsForcedUpgrade = (Boolean)UIUtil.invokeAndWaitIfNeeded(() -> new ForcedPluginPreviewVersionUpgradeDialog(project, pluginInfo).showAndGet());
        if (userAcceptsForcedUpgrade) {
            AndroidPluginVersionUpdater versionUpdater = AndroidPluginVersionUpdater.getInstance(project);
            versionUpdater.updatePluginVersionAndSync(recommended, GradleVersion.parse((String)"4.1"), true);
        } else {
            String[] text = new String[]{"The project is using an incompatible version of the " + pluginGeneration.getDescription() + ".", "Please update your project to use version " + pluginGeneration.getLatestKnownVersion() + "."};
            SyncMessage msg = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, text);
            String pluginName = AndroidPluginGeneration.getGroupId() + ":" + pluginGeneration.getArtifactId();
            SearchInBuildFilesHyperlink quickFix = new SearchInBuildFilesHyperlink(pluginName);
            msg.add(quickFix);
            GradleSyncMessages.getInstance(project).report(msg);
            syncState.invalidateLastSync("Force plugin upgrade declined");
        }
        return true;
    }

    @VisibleForTesting
    static boolean shouldPreviewBeForcedToUpgradePluginVersion(@NotNull GradleVersion recommended, @Nullable GradleVersion current) {
        if (current != null && current.getPreviewType() != null) {
            if (recommended.isSnapshot() && current.compareIgnoringQualifiers(recommended) == 0) {
                return false;
            }
            if (recommended.isAtLeast(2, 4, 0, "alpha", 8, false)) {
                if (current.compareTo(recommended) >= 0) {
                    return false;
                }
                boolean isOlderPreviewAllowed = current.isPreview() && current.getMajor() == 2 && current.getMinor() == 4 && current.compareTo(recommended) < 0;
                return !isOlderPreviewAllowed;
            }
            return current.compareTo(recommended) < 0;
        }
        return false;
    }
}

