/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.project.PropertyBasedDoNotAskOption;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.TimeBasedUpgradeReminder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecommendedPluginVersionUpgradeDialog
extends DialogWrapper {
    private static final String SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME = "show.do.not.ask.upgrade.gradle.plugin";
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleVersion myCurrentPluginVersion;
    @NotNull
    private final TimeBasedUpgradeReminder myUpgradeReminder;
    @NotNull
    private final PropertyBasedDoNotAskOption myDoNotAskOption;
    private JPanel myCenterPanel;
    private JEditorPane myMessagePane;
    private JButton[] myButtons;

    @VisibleForTesting
    RecommendedPluginVersionUpgradeDialog(@NotNull Project project, @NotNull GradleVersion current, @NotNull GradleVersion recommended, @NotNull TimeBasedUpgradeReminder upgradeReminder) {
        super(project);
        this.myProject = project;
        this.myCurrentPluginVersion = current;
        this.myUpgradeReminder = upgradeReminder;
        this.$$$setupUI$$$();
        this.setTitle("Android Gradle Plugin Update Recommended");
        this.myDoNotAskOption = new PropertyBasedDoNotAskOption(project, SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME){

            @Override
            @NotNull
            public String getDoNotShowMessage() {
                return "Don't remind me again for this project";
            }

            @Override
            public boolean isToBeShown() {
                return RecommendedPluginVersionUpgradeDialog.this.shouldDisplayDialog();
            }

            @Override
            public void setToBeShown(boolean toBeShown, int exitCode) {
                String valueToSave = "";
                if (!toBeShown) {
                    valueToSave = RecommendedPluginVersionUpgradeDialog.this.myCurrentPluginVersion.toString();
                }
                PropertiesComponent.getInstance((Project)RecommendedPluginVersionUpgradeDialog.this.myProject).setValue(RecommendedPluginVersionUpgradeDialog.SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME, valueToSave);
            }
        };
        this.init();
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myMessagePane);
        String msg = "To take advantage of all the latest features (such as <b><a href='https://developer.android.com/studio/run/index.html#instant-run\"'>Instant Run</a></b>), improvements and security fixes, we strongly recommend that you update the Android Gradle plugin to version " + recommended + " and Gradle to version " + "4.1" + ".<br/><br/>You can learn more about this version of the plugin from the <a href='http://developer.android.com/tools/revisions/gradle-plugin.html'>release notes</a>.<br/><br/>";
        this.myMessagePane.setText(msg);
        this.myMessagePane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
    }

    @NotNull
    protected JComponent createSouthPanel() {
        Action[] actions = this.createActions();
        ArrayList buttons = Lists.newArrayList();
        JPanel panel = new JPanel(new BorderLayout());
        if (actions.length > 0) {
            JPanel buttonsPanel = this.createButtons(actions, buttons);
            panel.add((Component)buttonsPanel, "Center");
            this.myButtons = buttons.toArray(new JButton[buttons.size()]);
        }
        if (this.getStyle() == DialogWrapper.DialogStyle.COMPACT) {
            CustomLineBorder line = new CustomLineBorder(OnePixelDivider.BACKGROUND, 1, 0, 0, 0);
            panel.setBorder(new CompoundBorder((Border)line, (Border)JBUI.Borders.empty((int)8, (int)12)));
        } else {
            panel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        }
        return panel;
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            return new Action[]{new DoNotAskAction(), new RemindMeTomorrowAction(), this.getOKAction()};
        }
        return new Action[]{this.getOKAction(), new RemindMeTomorrowAction(), new DoNotAskAction()};
    }

    @NotNull
    protected Action getOKAction() {
        Action action = super.getOKAction();
        action.putValue("Name", "Update");
        return action;
    }

    public void doCancelAction() {
        this.close(1);
    }

    @NotNull
    private JPanel createButtons(@NotNull Action[] actions, @NotNull List<JButton> buttons) {
        JPanel buttonsPanel = new JPanel(new FlowLayout(4));
        for (Action action : actions) {
            JButton button = this.createJButtonForAction(action);
            Object value = action.getValue("MnemonicKey");
            if (value instanceof Integer) {
                int mnemonic = (Integer)value;
                button.setMnemonic(mnemonic);
            }
            if (action.getValue("FocusedAction") != null) {
                this.myPreferredFocusedComponent = button;
            }
            buttons.add(button);
            buttonsPanel.add(button);
        }
        return buttonsPanel;
    }

    public void show() {
        if (this.shouldDisplayDialog()) {
            super.show();
        } else {
            this.doCancelAction();
        }
    }

    private boolean shouldDisplayDialog() {
        String value = PropertiesComponent.getInstance((Project)this.myProject).getValue(SHOW_DO_NOT_ASK_TO_UPGRADE_PLUGIN_PROPERTY_NAME, "");
        boolean storedVersionMatching = StringUtil.isNotEmpty((String)value) && this.myCurrentPluginVersion.compareTo(value) == 0;
        return !storedVersionMatching;
    }

    protected void dispose() {
        super.dispose();
        if (this.myButtons != null) {
            for (JButton button : this.myButtons) {
                button.setAction(null);
            }
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        this.myCenterPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMessagePane = jEditorPane = new JEditorPane();
        jPanel.add((Component)jEditorPane, new GridConstraints(0, 0, 1, 1, 1, 1, 6, 6, null, new Dimension(470, 130), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myCenterPanel;
    }

    @VisibleForTesting
    class RemindMeTomorrowAction
    extends DialogWrapper.DialogWrapperAction {
        RemindMeTomorrowAction() {
            super((DialogWrapper)RecommendedPluginVersionUpgradeDialog.this, "Remind me tomorrow");
        }

        protected void doAction(ActionEvent e) {
            RecommendedPluginVersionUpgradeDialog.this.myUpgradeReminder.storeLastUpgradeRecommendation(RecommendedPluginVersionUpgradeDialog.this.myProject);
            RecommendedPluginVersionUpgradeDialog.this.close(1);
        }
    }

    private class DoNotAskAction
    extends DialogWrapper.DialogWrapperAction {
        protected DoNotAskAction() {
            super((DialogWrapper)RecommendedPluginVersionUpgradeDialog.this, RecommendedPluginVersionUpgradeDialog.this.myDoNotAskOption.getDoNotShowMessage());
        }

        protected void doAction(ActionEvent e) {
            RecommendedPluginVersionUpgradeDialog.this.myDoNotAskOption.setToBeShown(false, 1);
            RecommendedPluginVersionUpgradeDialog.this.doCancelAction();
        }
    }

    public static class Factory {
        @NotNull
        public RecommendedPluginVersionUpgradeDialog create(@NotNull Project project, @NotNull GradleVersion current, @NotNull GradleVersion recommended) {
            return new RecommendedPluginVersionUpgradeDialog(project, current, recommended, new TimeBasedUpgradeReminder());
        }
    }
}

