/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.RecommendedPluginVersionUpgradeDialog;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.TimeBasedUpgradeReminder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecommendedPluginVersionUpgradeStep
extends PluginVersionUpgradeStep {
    @NotNull
    private final RecommendedPluginVersionUpgradeDialog.Factory myUpgradeDialogFactory;
    @NotNull
    private final TimeBasedUpgradeReminder myUpgradeReminder;

    public RecommendedPluginVersionUpgradeStep() {
        this(new RecommendedPluginVersionUpgradeDialog.Factory(), new TimeBasedUpgradeReminder());
    }

    @VisibleForTesting
    RecommendedPluginVersionUpgradeStep(@NotNull RecommendedPluginVersionUpgradeDialog.Factory upgradeDialogFactory, @NotNull TimeBasedUpgradeReminder upgradeReminder) {
        this.myUpgradeDialogFactory = upgradeDialogFactory;
        this.myUpgradeReminder = upgradeReminder;
    }

    @Override
    public boolean checkAndPerformUpgrade(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        if (this.myUpgradeReminder.shouldRecommendUpgrade(project) && RecommendedPluginVersionUpgradeStep.shouldRecommendUpgrade(pluginInfo)) {
            GradleVersion latestGradleVersion;
            AndroidPluginVersionUpdater updater;
            AndroidPluginVersionUpdater.UpdateResult result;
            GradleVersion current = pluginInfo.getPluginVersion();
            assert (current != null);
            AndroidPluginGeneration pluginGeneration = pluginInfo.getPluginGeneration();
            GradleVersion recommended = GradleVersion.parse((String)pluginGeneration.getLatestKnownVersion());
            Computable promptUserTask = () -> {
                RecommendedPluginVersionUpgradeDialog updateDialog = this.myUpgradeDialogFactory.create(project, current, recommended);
                return updateDialog.showAndGet();
            };
            boolean userAcceptsUpgrade = ApplicationManager.getApplication().isUnitTestMode() ? ((Boolean)promptUserTask.compute()).booleanValue() : ((Boolean)UIUtil.invokeAndWaitIfNeeded((Computable)promptUserTask)).booleanValue();
            if (userAcceptsUpgrade && (result = (updater = AndroidPluginVersionUpdater.getInstance(project)).updatePluginVersionAndSync(recommended, latestGradleVersion = GradleVersion.parse((String)"4.1"), false)).versionUpdateSuccess()) {
                return true;
            }
        }
        return false;
    }

    private static boolean shouldRecommendUpgrade(@NotNull AndroidPluginInfo androidPluginInfo) {
        GradleVersion current = androidPluginInfo.getPluginVersion();
        GradleVersion recommended = GradleVersion.parse((String)androidPluginInfo.getPluginGeneration().getLatestKnownVersion());
        return RecommendedPluginVersionUpgradeStep.shouldRecommendUpgrade(recommended, current);
    }

    @VisibleForTesting
    static boolean shouldRecommendUpgrade(@NotNull GradleVersion recommended, @Nullable GradleVersion current) {
        if (current != null) {
            if (recommended.isSnapshot() && current.getPreviewType() != null && current.compareIgnoringQualifiers(recommended) == 0) {
                return false;
            }
            return current.compareTo(recommended) < 0;
        }
        return false;
    }
}

