/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TimeBasedUpgradeReminder {
    private static final String SYNC_PLUGIN_LAST_UPGRADE_TIMESTAMP_PROPERTY = "sync.plugin.last.upgrade.timestamp";

    TimeBasedUpgradeReminder() {
    }

    boolean shouldRecommendUpgrade(@NotNull Project project) {
        return this.shouldRecommendUpgrade(project, System.currentTimeMillis());
    }

    @VisibleForTesting
    boolean shouldRecommendUpgrade(@NotNull Project project, long currentTimeInMs) {
        String lastTimestampValue = this.getStoredTimestamp(project);
        if (StringUtil.isNotEmpty((String)lastTimestampValue)) {
            try {
                long lastTimestamp = Long.parseLong(lastTimestampValue);
                long elapsed = currentTimeInMs - lastTimestamp;
                long days = TimeUnit.MILLISECONDS.toDays(elapsed);
                return days >= 1L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    @VisibleForTesting
    @Nullable
    String getStoredTimestamp(@NotNull Project project) {
        return PropertiesComponent.getInstance((Project)project).getValue(SYNC_PLUGIN_LAST_UPGRADE_TIMESTAMP_PROPERTY);
    }

    void storeLastUpgradeRecommendation(@NotNull Project project) {
        this.storeLastUpgradeRecommendation(project, System.currentTimeMillis());
    }

    @VisibleForTesting
    void storeLastUpgradeRecommendation(@NotNull Project project, long currentTimeInMs) {
        PropertiesComponent.getInstance((Project)project).setValue(SYNC_PLUGIN_LAST_UPGRADE_TIMESTAMP_PROPERTY, String.valueOf(currentTimeInMs));
    }
}

