/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ExtraGeneratedFolderValidationStrategy
extends AndroidProjectValidationStrategy {
    @NotNull
    private final List<File> myExtraGeneratedSourceFolderPaths = new ArrayList<File>();

    ExtraGeneratedFolderValidationStrategy(@NotNull Project project) {
        super(project);
    }

    @Override
    void validate(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        File[] sourceFolderPaths = androidModel.getExtraGeneratedSourceFolderPaths();
        Collections.addAll(this.myExtraGeneratedSourceFolderPaths, sourceFolderPaths);
    }

    @Override
    void fixAndReportFoundIssues() {
        if (!this.myExtraGeneratedSourceFolderPaths.isEmpty()) {
            GradleSyncMessages messages = GradleSyncMessages.getInstance(this.getProject());
            Collections.sort(this.myExtraGeneratedSourceFolderPaths);
            for (File folder : this.myExtraGeneratedSourceFolderPaths) {
                String[] text = new String[]{"Folder " + folder.getPath()};
                messages.report(new SyncMessage("Generated Sources", MessageType.WARNING, text));
            }
            messages.report(new SyncMessage("Generated Sources", MessageType.INFO, "3rd-party Gradle plug-ins may be the cause"));
        }
    }

    @VisibleForTesting
    @NotNull
    List<File> getExtraGeneratedSourceFolderPaths() {
        return this.myExtraGeneratedSourceFolderPaths;
    }
}

