/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.common;

import com.android.tools.idea.gradle.project.sync.validation.common.CommonProjectValidationStrategy;
import com.android.tools.idea.gradle.project.sync.validation.common.UniquePathModuleValidatorStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class CommonModuleValidator {
    public abstract void validate(@NotNull Module var1);

    public abstract void fixAndReportFoundIssues();

    @VisibleForTesting
    static class CommonModuleValidatorImpl
    extends CommonModuleValidator {
        @NotNull
        private final CommonProjectValidationStrategy[] myStrategies;

        CommonModuleValidatorImpl(@NotNull Project project) {
            this(new UniquePathModuleValidatorStrategy(project));
        }

        @VisibleForTesting
        CommonModuleValidatorImpl(CommonProjectValidationStrategy ... strategies) {
            this.myStrategies = strategies;
        }

        @Override
        public void validate(@NotNull Module module) {
            for (CommonProjectValidationStrategy strategy : this.myStrategies) {
                strategy.validate(module);
            }
        }

        @Override
        public void fixAndReportFoundIssues() {
            for (CommonProjectValidationStrategy strategy : this.myStrategies) {
                strategy.fixAndReportFoundIssues();
            }
        }

        @VisibleForTesting
        @NotNull
        CommonProjectValidationStrategy[] getStrategies() {
            return this.myStrategies;
        }
    }

    public static class Factory {
        @NotNull
        public CommonModuleValidator create(@NotNull Project project) {
            return new CommonModuleValidatorImpl(project);
        }
    }
}

