/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GradleInstantRunContext
implements InstantRunContext {
    private final String myApplicationId;
    private final AndroidFacet myFacet;
    private final AndroidModuleModel myModel;
    private BuildSelection myBuildChoice;

    public GradleInstantRunContext(@NotNull String applicationId, @NotNull AndroidFacet appFacet) {
        this.myApplicationId = applicationId;
        this.myFacet = appFacet;
        this.myModel = AndroidModuleModel.get(appFacet);
    }

    @Override
    @Nullable
    public InstantRunBuildInfo getInstantRunBuildInfo() {
        return InstantRunGradleUtils.getBuildInfo(this.myModel);
    }

    @Override
    public void setBuildSelection(@NotNull BuildSelection buildSelection) {
        this.myBuildChoice = buildSelection;
    }

    @Override
    @Nullable
    public BuildSelection getBuildSelection() {
        return this.myBuildChoice;
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return this.myApplicationId;
    }

    @Override
    @NotNull
    public GradleVersion getGradlePluginVersion() {
        GradleVersion version = this.myModel.getModelVersion();
        return version == null ? new GradleVersion(0, 0, 0) : version;
    }

    @Override
    @NotNull
    public HashCode getManifestResourcesHash() {
        return GradleInstantRunContext.getManifestResourcesHash(this.myFacet);
    }

    @VisibleForTesting
    static HashCode getManifestResourcesHash(@NotNull AndroidFacet facet) {
        Document manifest = MergedManifest.get(facet).getDocument();
        if (manifest == null || manifest.getDocumentElement() == null) {
            return HashCode.fromInt((int)0);
        }
        Hasher hasher = Hashing.goodFastHash((int)32).newHasher();
        SortedSet<ResourceUrl> appResourceReferences = GradleInstantRunContext.getAppResourceReferences(manifest.getDocumentElement());
        AppResourceRepository appResources = AppResourceRepository.getOrCreateInstance(facet);
        ApplicationManager.getApplication().runReadAction(() -> GradleInstantRunContext.hashResources(appResourceReferences, appResources, hasher));
        return hasher.hash();
    }

    @VisibleForTesting
    static SortedSet<ResourceUrl> getAppResourceReferences(@NotNull Element element) {
        TreeSet<ResourceUrl> refs = new TreeSet<ResourceUrl>(Comparator.comparing(ResourceUrl::toString));
        GradleInstantRunContext.addAppResourceReferences(element, refs);
        return refs;
    }

    private static void addAppResourceReferences(@NotNull Element element, @NotNull Set<ResourceUrl> refs) {
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                ResourceUrl url;
                Node attribute = attributes.item(i);
                String value = attribute.getNodeValue();
                if (!value.startsWith("@") || (url = ResourceUrl.parse((String)value)) == null || url.framework) continue;
                refs.add(url);
            }
        }
        NodeList children = element.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            GradleInstantRunContext.addAppResourceReferences((Element)child, refs);
        }
    }

    private static void hashResources(@NotNull SortedSet<ResourceUrl> appResources, @NotNull AppResourceRepository resources, @NotNull Hasher hasher) {
        for (ResourceUrl url : appResources) {
            List items = resources.getResourceItem(url.type, url.name);
            if (items == null) continue;
            for (ResourceItem item : items) {
                String text;
                ResourceValue resourceValue = item.getResourceValue(false);
                if (resourceValue == null || (text = resourceValue.getValue()) == null) continue;
                if (ResourceHelper.isFileBasedResourceType(url.type)) {
                    File f = new File(text);
                    if (!f.exists()) continue;
                    try {
                        hasher.putBytes(Files.toByteArray((File)f));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                hasher.putString((CharSequence)text, Charsets.UTF_8);
            }
        }
    }

    @Override
    public boolean usesMultipleProcesses() {
        Document manifest = MergedManifest.get(this.myFacet).getDocument();
        if (manifest == null) {
            return false;
        }
        return GradleInstantRunContext.manifestSpecifiesMultiProcess(manifest.getDocumentElement(), InstantRunManager.ALLOWED_MULTI_PROCESSES);
    }

    @Override
    @NotNull
    public List<String> getCustomBuildArguments() {
        if (this.myModel.getAndroidProject().getProjectType() != 0) {
            return Collections.emptyList();
        }
        GradleFacet facet = GradleFacet.getInstance(this.myFacet.getModule());
        if (facet == null) {
            Logger.getInstance(GradleInstantRunContext.class).warn("Unable to obtain gradle facet for module " + this.myFacet.getModule().getName());
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)AndroidGradleSettings.createProjectProperty((String)"android.injected.restrict.variant.name", (String)this.myModel.getSelectedVariant().getName()), (Object)AndroidGradleSettings.createProjectProperty((String)"android.injected.restrict.variant.project", (String)((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH));
    }

    static boolean manifestSpecifiesMultiProcess(@Nullable Element element, @NotNull Set<String> allowedProcesses) {
        if (element == null) {
            return false;
        }
        NodeList children = element.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !GradleInstantRunContext.manifestSpecifiesMultiProcess((Element)child, allowedProcesses)) continue;
            return true;
        }
        String process = element.getAttributeNS("http://schemas.android.com/apk/res/android", "process");
        return !process.isEmpty() && !allowedProcesses.contains(process);
    }
}

