/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.builder.model.TestedTargetVariant;
import com.android.ddmlib.IDevice;
import com.android.ide.common.repository.GradleVersion;
import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.fd.InstantRunBuilder;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidProject;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.DefaultGradleBuilder;
import com.android.tools.idea.gradle.run.GradleEditTaskDialog;
import com.android.tools.idea.gradle.run.GradleModuleTasksProvider;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Ordering;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import icons.AndroidIcons;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeBeforeRunTaskProvider
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    @NotNull
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Android.Gradle.BeforeRunTask");
    public static final String TASK_NAME = "Gradle-aware Make";
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final GradleTaskRunnerFactory myTaskRunnerFactory;

    public MakeBeforeRunTaskProvider(@NotNull Project project, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleProjectInfo gradleProjectInfo) {
        this.myProject = project;
        this.myAndroidProjectInfo = androidProjectInfo;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myTaskRunnerFactory = new GradleTaskRunnerFactory(this.myProject, GradleVersions.getInstance());
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(MakeBeforeRunTask task) {
        return AndroidIcons.Android;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String getDescription(MakeBeforeRunTask task) {
        String goal = task.getGoal();
        return StringUtil.isEmpty((String)goal) ? TASK_NAME : "gradle " + goal;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public MakeBeforeRunTask createTask(RunConfiguration runConfiguration) {
        if (this.configurationTypeIsSupported(runConfiguration)) {
            MakeBeforeRunTask task = new MakeBeforeRunTask();
            if (runConfiguration instanceof PreferGradleMake) {
                task.setEnabled(true);
            }
            return task;
        }
        return null;
    }

    private boolean configurationTypeIsSupported(@NotNull RunConfiguration runConfiguration) {
        if (this.myAndroidProjectInfo.isApkProject()) {
            return false;
        }
        return runConfiguration instanceof PreferGradleMake || MakeBeforeRunTaskProvider.isUnitTestConfiguration(runConfiguration);
    }

    private static boolean isUnitTestConfiguration(@NotNull RunConfiguration runConfiguration) {
        return runConfiguration instanceof JUnitConfiguration || runConfiguration.getClass().getSimpleName().equals("TestNGConfiguration");
    }

    public boolean configureTask(RunConfiguration runConfiguration, MakeBeforeRunTask task) {
        GradleEditTaskDialog dialog = new GradleEditTaskDialog(this.myProject);
        dialog.setGoal(task.getGoal());
        dialog.setAvailableGoals(this.createAvailableTasks());
        if (!dialog.showAndGet()) {
            task.setInvalid();
            return false;
        }
        task.setGoal(dialog.getGoal());
        return true;
    }

    @NotNull
    private List<String> createAvailableTasks() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList<String> gradleTasks = new ArrayList<String>();
        for (Module module : moduleManager.getModules()) {
            GradleModuleModel gradleModuleModel;
            GradleFacet facet = GradleFacet.getInstance(module);
            if (facet == null || (gradleModuleModel = facet.getGradleModuleModel()) == null) continue;
            gradleTasks.addAll(gradleModuleModel.getTaskNames());
        }
        return gradleTasks;
    }

    public boolean canExecuteTask(RunConfiguration configuration, MakeBeforeRunTask task) {
        return task.isValid();
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, MakeBeforeRunTask task) {
        String errorMsg;
        GradleSyncState syncState;
        if (!this.myAndroidProjectInfo.requiresAndroidModel() || !this.myGradleProjectInfo.isDirectGradleBuildEnabled()) {
            CompileStepBeforeRun regularMake = new CompileStepBeforeRun(this.myProject);
            return regularMake.executeTask(context, configuration, env, new CompileStepBeforeRun.MakeBeforeRunTask());
        }
        final AtomicReference errorMsgRef = new AtomicReference();
        if (AndroidGradleBuildConfiguration.getInstance((Project)this.myProject).SYNC_PROJECT_BEFORE_BUILD && (syncState = GradleSyncState.getInstance(this.myProject)).isSyncNeeded() != ThreeState.NO) {
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setRunInBackground(false).setTrigger(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
            GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request, new GradleSyncListener.Adapter(){

                @Override
                public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                    errorMsgRef.set(errorMessage);
                }
            });
        }
        if ((errorMsg = (String)errorMsgRef.get()) != null) {
            MakeBeforeRunTaskProvider.getLog().info("Unable to launch 'Gradle-aware Make' task. Project sync failed with message: " + errorMsg);
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (configuration instanceof RunConfigurationBase && ((RunConfigurationBase)configuration).excludeCompileBeforeLaunchOption()) {
            return true;
        }
        AndroidRunConfigContext runConfigContext = (AndroidRunConfigContext)env.getCopyableUserData(AndroidRunConfigContext.KEY);
        DeviceFutures deviceFutures = runConfigContext == null ? null : runConfigContext.getTargetDevices();
        List<AndroidDevice> targetDevices = deviceFutures == null ? Collections.emptyList() : deviceFutures.getDevices();
        List<String> cmdLineArgs = MakeBeforeRunTaskProvider.getCommonArguments(configuration, targetDevices);
        BeforeRunBuilder builder = MakeBeforeRunTaskProvider.createBuilder(env, MakeBeforeRunTaskProvider.getModules(this.myProject, context, configuration), configuration, runConfigContext, task.getGoal());
        GradleTaskRunner.DefaultGradleTaskRunner runner = this.myTaskRunnerFactory.createTaskRunner(configuration);
        try {
            boolean success = builder.build(runner, cmdLineArgs);
            if (configuration instanceof AndroidRunConfigurationBase) {
                Object model = runner.getModel();
                if (model != null && model instanceof OutputBuildAction.PostBuildProjectModels) {
                    ((AndroidRunConfigurationBase)configuration).setOutputModel(new PostBuildModel((OutputBuildAction.PostBuildProjectModels)model));
                } else {
                    MakeBeforeRunTaskProvider.getLog().info("Couldn't get post build models.");
                }
            }
            MakeBeforeRunTaskProvider.getLog().info("Gradle invocation complete, success = " + success);
            return success;
        }
        catch (InvocationTargetException e) {
            MakeBeforeRunTaskProvider.getLog().info("Unexpected error while launching gradle before run tasks", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            MakeBeforeRunTaskProvider.getLog().info("Interrupted while launching gradle before run tasks");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(MakeBeforeRunTask.class);
    }

    @NotNull
    private static List<String> getCommonArguments(@NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        ArrayList<String> cmdLineArgs = new ArrayList<String>();
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getDeviceSpecificArguments(targetDevices));
        cmdLineArgs.addAll(MakeBeforeRunTaskProvider.getProfilingOptions(configuration, targetDevices));
        return cmdLineArgs;
    }

    @NotNull
    public static List<String> getDeviceSpecificArguments(@NotNull List<AndroidDevice> devices) {
        if (devices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> properties = new ArrayList<String>(2);
        List versionLists = devices.stream().map(AndroidDevice::getVersion).collect(Collectors.toList());
        AndroidVersion minVersion = (AndroidVersion)Ordering.natural().min(versionLists);
        properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.api", (String)Integer.toString(minVersion.getApiLevel())));
        if (minVersion.getCodename() != null) {
            properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.codename", (String)minVersion.getCodename()));
        }
        if (devices.size() == 1) {
            List abis;
            AndroidDevice device = devices.get(0);
            Density density = Density.getEnum((int)device.getDensity());
            if (density != null) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.density", (String)density.getResourceValue()));
            }
            if (!(abis = device.getAbis().stream().map(Abi::toString).collect(Collectors.toList())).isEmpty()) {
                properties.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.abi", (String)Joiner.on((char)',').join(abis)));
            }
        }
        return properties;
    }

    @NotNull
    public static List<String> getProfilingOptions(@NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> devices) {
        if (!StudioFlags.PROFILER_ENABLED.get().booleanValue() || !(configuration instanceof AndroidRunConfigurationBase) || devices.isEmpty()) {
            return Collections.emptyList();
        }
        List versionLists = devices.stream().map(AndroidDevice::getVersion).collect(Collectors.toList());
        AndroidVersion minVersion = (AndroidVersion)Ordering.natural().min(versionLists);
        LinkedList<String> arguments = new LinkedList<String>();
        ProfilerState state = ((AndroidRunConfigurationBase)configuration).getProfilerState();
        if (state.ADVANCED_PROFILING_ENABLED && (minVersion.getFeatureLevel() < 26 || !StudioFlags.PROFILER_USE_JVMTI.get().booleanValue())) {
            File file = EmbeddedDistributionPaths.getInstance().findEmbeddedProfilerTransform(minVersion);
            arguments.add(AndroidGradleSettings.createProjectProperty((String)"android.advanced.profiling.transforms", (String)file.getAbsolutePath()));
            Properties profilerProperties = state.toProperties();
            try {
                File propertiesFile = FileUtil.createTempFile((String)"profiler", (String)".properties");
                propertiesFile.deleteOnExit();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), Charsets.UTF_8);
                profilerProperties.store(writer, "Android Studio Profiler Gradle Plugin Properties");
                ((Writer)writer).close();
                arguments.add(AndroidGradleSettings.createJvmArg((String)"android.profiler.properties", (String)propertiesFile.getAbsolutePath()));
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return arguments;
    }

    private static BeforeRunBuilder createBuilder(@NotNull ExecutionEnvironment env, @NotNull Module[] modules, @NotNull RunConfiguration configuration, @Nullable AndroidRunConfigContext runConfigContext, @Nullable String userGoal) {
        DeviceFutures deviceFutures;
        if (modules.length == 0) {
            throw new IllegalStateException("Unable to determine list of modules to build");
        }
        if (!StringUtil.isEmpty((String)userGoal)) {
            return new DefaultGradleBuilder(Collections.singletonList(userGoal), null);
        }
        GradleModuleTasksProvider gradleTasksProvider = new GradleModuleTasksProvider(modules);
        TestCompileType testCompileType = TestCompileType.get(configuration.getType().getId());
        if (testCompileType == TestCompileType.UNIT_TESTS) {
            BuildMode buildMode = BuildMode.COMPILE_JAVA;
            return new DefaultGradleBuilder(gradleTasksProvider.getUnitTestTasks(buildMode), buildMode);
        }
        InstantRunContext irContext = (InstantRunContext)env.getCopyableUserData(InstantRunContext.KEY);
        DeviceFutures deviceFutures2 = deviceFutures = runConfigContext == null ? null : runConfigContext.getTargetDevices();
        if (deviceFutures == null || irContext == null) {
            return new DefaultGradleBuilder(gradleTasksProvider.getTasksFor(BuildMode.ASSEMBLE, testCompileType), BuildMode.ASSEMBLE);
        }
        List<AndroidDevice> targetDevices = deviceFutures.getDevices();
        assert (targetDevices.size() == 1) : "instant run context available, but deploying to > 1 device";
        return new InstantRunBuilder(MakeBeforeRunTaskProvider.getLaunchedDevice(targetDevices.get(0)), irContext, runConfigContext, gradleTasksProvider);
    }

    @NotNull
    private static Module[] getModules(@NotNull Project project, @Nullable DataContext context, @Nullable RunConfiguration configuration) {
        if (configuration instanceof ModuleRunProfile) {
            if (configuration instanceof AndroidJUnitConfiguration) {
                return ((AndroidJUnitConfiguration)configuration).getModulesToCompile();
            }
            return ((ModuleRunProfile)configuration).getModules();
        }
        return Projects.getModulesToBuildFromSelection(project, context);
    }

    @Nullable
    public static IDevice getLaunchedDevice(@NotNull AndroidDevice device) {
        if (!device.getLaunchedDevice().isDone()) {
            return null;
        }
        try {
            return (IDevice)device.getLaunchedDevice().get(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
    }

    @VisibleForTesting
    static class GradleTaskRunnerFactory {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GradleVersions myGradleVersions;

        GradleTaskRunnerFactory(@NotNull Project project, @NotNull GradleVersions gradleVersions) {
            this.myProject = project;
            this.myGradleVersions = gradleVersions;
        }

        @NotNull
        GradleTaskRunner.DefaultGradleTaskRunner createTaskRunner(@NotNull RunConfiguration configuration) {
            GradleVersion version;
            if (configuration instanceof AndroidRunConfigurationBase && (version = this.myGradleVersions.getGradleVersion(this.myProject)) != null && version.isAtLeast(3, 5, 0)) {
                Module selectedModule = ((JavaRunConfigurationModule)((AndroidRunConfigurationBase)configuration).getConfigurationModule()).getModule();
                return GradleTaskRunner.newBuildActionRunner(this.myProject, new OutputBuildAction(GradleTaskRunnerFactory.getConcernedGradlePaths(selectedModule)));
            }
            return GradleTaskRunner.newRunner(this.myProject);
        }

        @NotNull
        private static Collection<String> getConcernedGradlePaths(@Nullable Module module) {
            IdeAndroidProject androidProject;
            if (module == null) {
                return Collections.emptySet();
            }
            HashSet<String> gradlePaths = new HashSet<String>();
            gradlePaths.add(GradleUtil.getGradlePath(module));
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel != null && (androidProject = androidModel.getAndroidProject()).getProjectType() == 2) {
                for (TestedTargetVariant testedVariant : androidModel.getSelectedVariant().getTestedTargetVariants()) {
                    gradlePaths.add(testedVariant.getTargetProjectPath());
                }
            }
            return gradlePaths;
        }
    }
}

