/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.actions.AndroidNewModuleAction;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.structure.ConfigurationErrorsPanel;
import com.android.tools.idea.gradle.structure.IdeSdksConfigurable;
import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.android.tools.idea.gradle.structure.editors.AndroidModuleConfigurable;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectConfigurable;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServices;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.android.tools.idea.structure.services.view.ServiceCategoryConfigurable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ThreeState;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectStructureConfigurable
extends BaseConfigurable
implements GradleSyncListener,
SearchableConfigurable,
Configurable.NoScroll {
    public static final DataKey<AndroidProjectStructureConfigurable> KEY = DataKey.create((String)"AndroidProjectStructureConfiguration");
    private static final Logger LOG = Logger.getInstance(AndroidProjectStructureConfigurable.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Disposable myDisposable;
    private boolean myUiInitialized;
    private JPanel myNotificationPanel;
    private Splitter mySplitter;
    private SidePanel mySidePanel;
    private ConfigurationErrorsPanel myErrorsPanel;
    @NotNull
    private final Wrapper myDetails = new Wrapper();
    @NotNull
    private final UiState myUiState;
    @NotNull
    private final IdeSdksConfigurable mySdksConfigurable;
    @NotNull
    private final List<Configurable> myConfigurables = Lists.newLinkedList();
    private final GradleSettingsFile mySettingsFile;

    @NotNull
    public static AndroidProjectStructureConfigurable getInstance(@NotNull Project project) {
        return (AndroidProjectStructureConfigurable)ServiceManager.getService((Project)project, AndroidProjectStructureConfigurable.class);
    }

    public boolean showDialogAndChooseJdkLocation() {
        return this.doShowDialog(() -> this.mySidePanel.chooseJdkLocation());
    }

    public boolean showDialogAndSelectSdksPage() {
        return this.doShowDialog(() -> this.mySidePanel.selectSdk());
    }

    public boolean showDialogAndSelect(@NotNull Module module) {
        return this.doShowDialog(() -> this.mySidePanel.select(module));
    }

    public boolean showDialogAndOpenSigningConfiguration(@NotNull Module module) {
        return this.doShowDialog(() -> {
            AndroidModuleConfigurable configurable = this.mySidePanel.select(module);
            if (configurable != null) {
                configurable.openSigningConfiguration();
            }
        });
    }

    public boolean showDialogAndSelectDependency(@NotNull Module module, @NotNull GradleCoordinate dependency) {
        return this.doShowDialog(() -> {
            AndroidModuleConfigurable configurable = this.mySidePanel.select(module);
            if (configurable != null) {
                configurable.selectDependency(dependency);
            }
        });
    }

    public boolean showDialogAndSelectBuildTypesEditor(@NotNull Module module) {
        return this.doShowDialog(() -> {
            AndroidModuleConfigurable configurable = this.mySidePanel.select(module);
            if (configurable != null) {
                configurable.selectBuildTypesTab();
            }
        });
    }

    public boolean showDialogAndSelectFlavorsEditor(@NotNull Module module) {
        return this.doShowDialog(() -> {
            AndroidModuleConfigurable configurable = this.mySidePanel.select(module);
            if (configurable != null) {
                configurable.selectFlavorsTab();
            }
        });
    }

    public boolean showDialogAndSelectDependenciesEditor(@NotNull Module module) {
        return this.doShowDialog(() -> {
            AndroidModuleConfigurable configurable = this.mySidePanel.select(module);
            if (configurable != null) {
                configurable.selectDependenciesTab();
            }
        });
    }

    public boolean showDialog() {
        return this.doShowDialog(null);
    }

    private boolean doShowDialog(@Nullable Runnable advanceInit) {
        String appId = ProjectStructureUsageTracker.getApplicationId(this.myProject);
        if (appId != null) {
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_STRUCTURE_DIALOG).setKind(AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_OPEN).setProjectId(AnonymizerUtil.anonymizeUtf8((String)appId)));
        }
        return ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)this, advanceInit);
    }

    public AndroidProjectStructureConfigurable(@NotNull Project project) {
        this.myProject = project;
        this.myUiState = new UiState(project);
        this.mySdksConfigurable = new IdeSdksConfigurable(this, project);
        this.myConfigurables.add((Configurable)this.mySdksConfigurable);
        if (!project.isDefault()) {
            this.myConfigurables.add((Configurable)new AndroidProjectConfigurable(project));
        }
        this.mySettingsFile = GradleSettingsFile.get(project);
        this.myDisposable = () -> {};
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"project.settings.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        MainPanel component2 = new MainPanel();
        this.mySplitter = new Splitter(false, 0.15f);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.initSidePanel();
        this.mySplitter.setFirstComponent((JComponent)this.mySidePanel);
        this.mySplitter.setSecondComponent((JComponent)this.myDetails);
        component2.add((Component)this.mySplitter, "Center");
        this.myNotificationPanel = new JPanel();
        Color background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        if (background == null) {
            background = JBColor.GRAY;
        }
        this.myNotificationPanel.setBackground(background);
        this.myNotificationPanel.setLayout(new BoxLayout(this.myNotificationPanel, 1));
        component2.add((Component)this.myNotificationPanel, "North");
        this.myErrorsPanel = new ConfigurationErrorsPanel();
        component2.add((Component)this.myErrorsPanel, "South");
        this.myUiInitialized = true;
        GradleSyncState.subscribe(this.myProject, this);
        return component2;
    }

    private void initSidePanel() {
        this.mySidePanel = new SidePanel();
    }

    public boolean isModified() {
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return super.isModified();
    }

    public void apply() throws ConfigurationException {
        String appId = ProjectStructureUsageTracker.getApplicationId(this.myProject);
        if (appId != null) {
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_STRUCTURE_DIALOG).setKind(AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_SAVE).setProjectId(AnonymizerUtil.anonymizeUtf8((String)appId)));
        }
        this.validateState();
        if (this.myErrorsPanel.hasCriticalErrors()) {
            return;
        }
        boolean dataChanged = false;
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            if (appId != null) {
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_STRUCTURE_DIALOG).setKind(AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_LEFT_NAV_SAVE).setProjectId(AnonymizerUtil.anonymizeUtf8((String)appId)));
            }
            dataChanged = true;
            configurable.apply();
        }
        if (!this.myProject.isDefault() && (dataChanged || GradleSyncState.getInstance(this.myProject).isSyncNeeded() == ThreeState.YES)) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Resetting project structure");
        try {
            for (Configurable configurable : this.myConfigurables) {
                configurable.reset();
            }
            if (this.myUiInitialized) {
                this.validateState();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
                Module[] modules = moduleManager.getModules();
                Arrays.sort(modules, ModuleTypeComparator.INSTANCE);
                ArrayList moduleConfigurables = Lists.newArrayList();
                for (Module module : modules) {
                    AndroidModuleConfigurable androidModuleConfigurable = this.addModule(module);
                    if (androidModuleConfigurable == null) continue;
                    moduleConfigurables.add(androidModuleConfigurable);
                }
                this.removeServices();
                if (Projects.isBuildWithGradle(this.myProject)) {
                    DefaultComboBoxModel<Module> moduleList = new DefaultComboBoxModel<Module>();
                    for (AndroidModuleConfigurable moduleConfigurable : moduleConfigurables) {
                        if (AndroidFacet.getInstance(moduleConfigurable.getModule()) == null) continue;
                        moduleList.addElement(moduleConfigurable.getModule());
                    }
                    if (!this.myProject.isDefault() && moduleList.getSize() > 0) {
                        for (int i = 0; i < moduleList.getSize(); ++i) {
                            Module module = (Module)moduleList.getElementAt(i);
                            for (DeveloperService developerService : DeveloperServices.getAll(module)) {
                                developerService.getContext().restore();
                            }
                        }
                        Module module = (Module)moduleList.getSelectedItem();
                        HashSet categories = Sets.newHashSet();
                        for (DeveloperService developerService : DeveloperServices.getAll(module)) {
                            if (developerService.getContext().hiddenFromStructureDialog().get().booleanValue()) continue;
                            categories.add(developerService.getCategory());
                        }
                        ArrayList categoriesSorted = Lists.newArrayList((Iterable)categories);
                        Collections.sort(categoriesSorted);
                        for (ServiceCategory category : categoriesSorted) {
                            this.myConfigurables.add(new ServiceCategoryConfigurable(moduleList, category));
                        }
                    }
                }
                this.removeModules();
                Module toSelect = null;
                for (Module module : modules) {
                    AndroidModuleConfigurable configurable = this.addModule(module);
                    if (configurable == null) continue;
                    this.myConfigurables.add((Configurable)configurable);
                    if (!configurable.getDisplayName().equals(this.myUiState.lastSelectedConfigurable)) continue;
                    toSelect = module;
                }
                if (this.myUiState.proportion > 0.0f) {
                    this.mySplitter.setProportion(this.myUiState.proportion);
                }
                this.mySidePanel.reset();
                if (toSelect != null) {
                    this.mySidePanel.select(toSelect);
                } else {
                    this.mySidePanel.selectSdk();
                }
            }
        }
        finally {
            token.finish();
        }
    }

    private void removeServices() {
        Iterator<Configurable> it = this.myConfigurables.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof ServiceCategoryConfigurable)) continue;
            it.remove();
        }
    }

    private void removeModules() {
        Iterator<Configurable> it = this.myConfigurables.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof AndroidModuleConfigurable)) continue;
            it.remove();
        }
    }

    @Nullable
    private AndroidModuleConfigurable addModule(@NotNull Module module) {
        String gradlePath = AndroidProjectStructureConfigurable.getGradlePath(module);
        AndroidModuleConfigurable configurable = null;
        if (StringUtil.isNotEmpty((String)gradlePath)) {
            configurable = new AndroidModuleConfigurable(this.myProject, module, gradlePath);
            configurable.reset();
        }
        return configurable;
    }

    private void validateState() {
        this.myErrorsPanel.removeAllErrors();
        List<ProjectConfigurationError> errors = this.mySdksConfigurable.validateState();
        if (!errors.isEmpty()) {
            Runnable navigationTask = () -> this.selectConfigurable((Configurable)this.mySdksConfigurable);
            for (ProjectConfigurationError error : errors) {
                error.setNavigationTask(navigationTask);
            }
        }
        this.myErrorsPanel.addErrors(errors);
    }

    @Nullable
    private static String getGradlePath(@NotNull Module module) {
        GradleFacet gradleFacet = GradleFacet.getInstance(module);
        return gradleFacet != null ? ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    private void selectConfigurable(@NotNull Configurable configurable) {
        String appId = ProjectStructureUsageTracker.getApplicationId(this.myProject);
        if (appId != null) {
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_STRUCTURE_DIALOG).setKind(AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_LEFT_NAV_CLICK).setProjectId(AnonymizerUtil.anonymizeUtf8((String)appId)));
        }
        JComponent content = configurable.createComponent();
        assert (content != null);
        this.myDetails.setContent(content);
        this.myUiState.lastSelectedConfigurable = configurable.getDisplayName();
        AndroidProjectStructureConfigurable.revalidateAndRepaint((JComponent)this.myDetails);
    }

    public void disposeUIResources() {
        if (!this.myUiInitialized) {
            return;
        }
        this.myUiState.storeValues(this.myProject);
        this.myUiState.proportion = this.mySplitter.getProportion();
        for (Configurable configurable : this.myConfigurables) {
            configurable.disposeUIResources();
        }
        Disposer.dispose((Disposable)this.myDisposable);
        Disposer.dispose((Disposable)this.myErrorsPanel);
        this.myUiInitialized = false;
    }

    @NotNull
    public String getId() {
        return "android.project.structure";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySidePanel != null ? this.mySidePanel.myList : null;
    }

    @Override
    public void syncStarted(@NotNull Project project) {
        if (this.myUiInitialized) {
            this.myNotificationPanel.removeAll();
            EditorNotificationPanel notification = new EditorNotificationPanel();
            notification.setText("Gradle project sync in progress...");
            this.myNotificationPanel.add((Component)notification);
            AndroidProjectStructureConfigurable.revalidateAndRepaint(this.myNotificationPanel);
        }
    }

    @Override
    public void setupStarted(@NotNull Project project) {
    }

    @Override
    public void syncSucceeded(@NotNull Project project) {
        this.myNotificationPanel.removeAll();
        AndroidProjectStructureConfigurable.revalidateAndRepaint(this.myNotificationPanel);
        this.reset();
    }

    @Override
    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
        this.myNotificationPanel.removeAll();
        AndroidProjectStructureConfigurable.revalidateAndRepaint(this.myNotificationPanel);
        this.reset();
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
    }

    private static void revalidateAndRepaint(@NotNull JComponent c) {
        c.revalidate();
        c.repaint();
    }

    public void requestValidation() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myErrorsPanel != null) {
                this.validateState();
            }
        });
    }

    private class DeleteModuleAction
    extends DumbAwareAction {
        @NotNull
        private final SidePanel mySidePanel;

        DeleteModuleAction(SidePanel sidePanel) {
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), CommonBundle.message((String)"button.delete", (Object[])new Object[0]), PlatformIcons.DELETE_ICON);
            this.mySidePanel = sidePanel;
            this.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)this.mySidePanel.myList);
        }

        public void actionPerformed(AnActionEvent e) {
            Object selectedValue = this.mySidePanel.myList.getSelectedValue();
            if (!(selectedValue instanceof AndroidModuleConfigurable)) {
                throw new IllegalStateException("The current selection does not represent a module");
            }
            AndroidModuleConfigurable configurable = (AndroidModuleConfigurable)((Object)selectedValue);
            Object editableObject = configurable.getEditableObject();
            if (!(editableObject instanceof Module)) {
                throw new IllegalStateException("Unable to find the module to delete");
            }
            String question = this.mySidePanel.getModuleCount() == 1 ? ProjectBundle.message((String)"module.remove.last.confirmation", (Object[])new Object[]{1}) : ProjectBundle.message((String)"module.remove.confirmation", (Object[])new Object[]{configurable.getDisplayName(), 1});
            if (Messages.showYesNoDialog((Project)AndroidProjectStructureConfigurable.this.myProject, (String)question, (String)ProjectBundle.message((String)"module.remove.confirmation.title", (Object[])new Object[]{1}), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            final Module module = (Module)editableObject;
            final String gradlePath = this.getGradlePath(module);
            if (StringUtil.isEmpty((String)gradlePath)) {
                String msg = String.format("The module '%1$s' does not have a Gradle path", module.getName());
                throw new IllegalStateException(msg);
            }
            RunResult result = new WriteCommandAction.Simple(module.getProject(), new PsiFile[0]){

                protected void run() throws Throwable {
                    DeleteModuleAction.this.delete(module);
                    if (AndroidProjectStructureConfigurable.this.mySettingsFile != null) {
                        AndroidProjectStructureConfigurable.this.mySettingsFile.removeModule(gradlePath);
                    }
                }
            }.execute();
            Throwable error = result.getThrowable();
            if (error != null) {
                String msg = String.format("Failed to remove module '%1$s'", module.getName());
                LOG.error(msg, error);
                return;
            }
            AndroidProjectStructureConfigurable.this.myConfigurables.remove((Object)configurable);
            this.mySidePanel.reset();
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(AndroidProjectStructureConfigurable.this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
        }

        @NotNull
        private String getGradlePath(@NotNull Module module) {
            GradleFacet facet = GradleFacet.getInstance(module);
            if (facet == null) {
                String msg = String.format("The module '%1$s' is not a Gradle module", module.getName());
                throw new IllegalStateException(msg);
            }
            String path = ((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH;
            if (StringUtil.isEmpty((String)path)) {
                String msg = String.format("The module '%1$s' does not have a Gradle path", module.getName());
                throw new IllegalStateException(msg);
            }
            return path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delete(@NotNull Module module) {
            if (module.isDisposed()) {
                return;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)module.getProject());
            ModifiableModuleModel modifiableModel = moduleManager.getModifiableModel();
            try {
                modifiableModel.disposeModule(module);
            }
            finally {
                modifiableModel.commit();
            }
        }

        public void update(AnActionEvent e) {
            Object selectedValue = this.mySidePanel.myList.getSelectedValue();
            e.getPresentation().setEnabled(selectedValue instanceof AndroidModuleConfigurable);
        }
    }

    private static class UiState {
        private static final String ANDROID_PROJECT_STRUCTURE_LAST_SELECTED_PROPERTY = "android.project.structure.last.selected";
        private static final String ANDROID_PROJECT_STRUCTURE_PROPORTION_PROPERTY = "android.project.structure.proportion";
        float proportion;
        String lastSelectedConfigurable;

        UiState(@NotNull Project project) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            this.lastSelectedConfigurable = propertiesComponent.getValue(ANDROID_PROJECT_STRUCTURE_LAST_SELECTED_PROPERTY);
            this.proportion = UiState.toFloat(propertiesComponent.getValue(ANDROID_PROJECT_STRUCTURE_PROPORTION_PROPERTY));
        }

        private static float toFloat(@Nullable String val) {
            if (val != null) {
                try {
                    return Float.parseFloat(val);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0.15f;
        }

        void storeValues(@NotNull Project project) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            propertiesComponent.setValue(ANDROID_PROJECT_STRUCTURE_LAST_SELECTED_PROPERTY, this.lastSelectedConfigurable);
            propertiesComponent.setValue(ANDROID_PROJECT_STRUCTURE_PROPORTION_PROPERTY, String.valueOf(this.proportion));
        }
    }

    private class SidePanel
    extends JPanel {
        @NotNull
        private final JBList myList;
        @NotNull
        private final DefaultListModel myListModel;
        @NotNull
        private final Map<Object, String> mySectionHeaderMap;

        SidePanel() {
            super(new BorderLayout());
            this.mySectionHeaderMap = Maps.newHashMap();
            this.myListModel = new DefaultListModel();
            this.myList = new JBList((ListModel)this.myListModel);
            ListItemDescriptor descriptor = new ListItemDescriptor(){

                @Nullable
                public String getTextFor(Object value) {
                    if (value instanceof Configurable) {
                        return ((Configurable)value).getDisplayName();
                    }
                    return value != null ? value.toString() : "";
                }

                @Nullable
                public String getTooltipFor(Object value) {
                    if (value instanceof AndroidModuleConfigurable) {
                        Module module = (Module)((AndroidModuleConfigurable)((Object)value)).getEditableObject();
                        return new File(module.getModuleFilePath()).getAbsolutePath();
                    }
                    return null;
                }

                @Nullable
                public Icon getIconFor(Object value) {
                    if (value instanceof AndroidModuleConfigurable) {
                        Module module = (Module)((AndroidModuleConfigurable)((Object)value)).getEditableObject();
                        return module.isDisposed() ? StudioIcons.Shell.Filetree.ANDROID_MODULE : GradleUtil.getModuleIcon(module);
                    }
                    return null;
                }

                public boolean hasSeparatorAboveOf(Object value) {
                    return SidePanel.this.mySectionHeaderMap.containsKey(value);
                }

                @Nullable
                public String getCaptionAboveOf(Object value) {
                    return this.hasSeparatorAboveOf(value) ? (String)SidePanel.this.mySectionHeaderMap.get(value) : null;
                }
            };
            this.myList.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer(descriptor));
            this.myList.setSelectionMode(0);
            this.myList.addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Object selection = this.myList.getSelectedValue();
                if (selection instanceof Configurable) {
                    AndroidProjectStructureConfigurable.this.selectConfigurable((Configurable)selection);
                }
            });
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myList, (int)20, (int)31);
            this.add((Component)scrollPane, "Center");
            if (!AndroidProjectStructureConfigurable.this.myProject.isDefault()) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add(this.createAddAction());
                group.add((AnAction)new DeleteModuleAction(this));
                JComponent toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
                this.add((Component)toolbar, "North");
            }
        }

        private void reset() {
            this.myListModel.clear();
            this.mySectionHeaderMap.clear();
            Class<?> activeSection = null;
            for (Configurable configurable : AndroidProjectStructureConfigurable.this.myConfigurables) {
                this.myListModel.addElement(configurable);
                if (activeSection == configurable.getClass()) continue;
                activeSection = configurable.getClass();
                if (configurable instanceof AndroidModuleConfigurable) {
                    this.mySectionHeaderMap.put(configurable, "Modules");
                    continue;
                }
                if (!(configurable instanceof ServiceCategoryConfigurable)) continue;
                this.mySectionHeaderMap.put(configurable, "Developer Services");
            }
        }

        @NotNull
        private AnAction createAddAction() {
            AndroidNewModuleAction action = new AndroidNewModuleAction("New Module", null, IconUtil.getAddIcon());
            Keymap active = KeymapManager.getInstance().getActiveKeymap();
            if (active != null) {
                Shortcut[] shortcuts = active.getShortcuts("NewElement");
                action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), this);
            }
            return action;
        }

        private int getModuleCount() {
            int count = 0;
            for (Configurable configurable : AndroidProjectStructureConfigurable.this.myConfigurables) {
                if (!(configurable instanceof AndroidModuleConfigurable)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension original = super.getMinimumSize();
            return new Dimension(Math.max(original.width, JBUI.scale((int)100)), original.height);
        }

        @Nullable
        AndroidModuleConfigurable select(@NotNull Module module) {
            for (int i = 0; i < this.myListModel.size(); ++i) {
                Object object = this.myListModel.elementAt(i);
                if (!(object instanceof AndroidModuleConfigurable) || ((AndroidModuleConfigurable)((Object)object)).getEditableObject() != module) continue;
                this.myList.setSelectedValue(object, true);
                return (AndroidModuleConfigurable)((Object)object);
            }
            return null;
        }

        void chooseJdkLocation() {
            this.selectSdk();
            AndroidProjectStructureConfigurable.this.mySdksConfigurable.chooseJdkLocation();
        }

        void selectSdk() {
            this.myList.setSelectedValue((Object)AndroidProjectStructureConfigurable.this.mySdksConfigurable, true);
        }
    }

    private class MainPanel
    extends JPanel
    implements DataProvider {
        MainPanel() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (KEY.is(dataId)) {
                return AndroidProjectStructureConfigurable.this;
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)800, (int)600);
        }
    }
}

