/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.structure.FastGradleSync;
import com.android.tools.idea.gradle.structure.daemon.PsAnalyzerDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsContext
implements Disposable {
    @NotNull
    private final PsProject myProject;
    @NotNull
    private final PsAnalyzerDaemon myAnalyzerDaemon;
    @NotNull
    private final FastGradleSync myGradleSync;
    @NotNull
    private final PsLibraryUpdateCheckerDaemon myLibraryUpdateCheckerDaemon;
    @NotNull
    private final EventDispatcher<ChangeListener> myChangeEventDispatcher = EventDispatcher.create(ChangeListener.class);
    @NotNull
    private final EventDispatcher<GradleSyncListener> myGradleSyncEventDispatcher = EventDispatcher.create(GradleSyncListener.class);
    @Nullable
    private String mySelectedModuleName;

    public PsContext(@NotNull PsProject project, @NotNull Disposable parentDisposable) {
        this.myProject = project;
        this.myGradleSync = new FastGradleSync();
        this.getMainConfigurable().add(this::requestGradleSync, this);
        this.myLibraryUpdateCheckerDaemon = new PsLibraryUpdateCheckerDaemon(this);
        this.myLibraryUpdateCheckerDaemon.reset();
        this.myLibraryUpdateCheckerDaemon.queueAutomaticUpdateCheck();
        this.myAnalyzerDaemon = new PsAnalyzerDaemon(this, this.myLibraryUpdateCheckerDaemon);
        this.myAnalyzerDaemon.reset();
        this.myProject.forEachModule(this.myAnalyzerDaemon::queueCheck);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    private void requestGradleSync() {
        Project project = this.myProject.getResolvedModel();
        ((GradleSyncListener)this.myGradleSyncEventDispatcher.getMulticaster()).syncStarted(project);
        FastGradleSync.Callback callback = this.myGradleSync.requestProjectSync(project);
        callback.doWhenDone(() -> ((GradleSyncListener)this.myGradleSyncEventDispatcher.getMulticaster()).syncSucceeded(project));
        callback.doWhenRejected(() -> {
            Throwable failure = callback.getFailure();
            assert (failure != null);
            ((GradleSyncListener)this.myGradleSyncEventDispatcher.getMulticaster()).syncFailed(project, ExceptionUtil.getRootCause((Throwable)failure).getMessage());
        });
    }

    public void add(@NotNull GradleSyncListener listener, @NotNull Disposable parentDisposable) {
        this.myGradleSyncEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    public PsAnalyzerDaemon getAnalyzerDaemon() {
        return this.myAnalyzerDaemon;
    }

    @NotNull
    public PsLibraryUpdateCheckerDaemon getLibraryUpdateCheckerDaemon() {
        return this.myLibraryUpdateCheckerDaemon;
    }

    @Nullable
    public String getSelectedModule() {
        return this.mySelectedModuleName;
    }

    public void setSelectedModule(@NotNull String moduleName, @NotNull Object source) {
        this.mySelectedModuleName = moduleName;
        ((ChangeListener)this.myChangeEventDispatcher.getMulticaster()).moduleSelectionChanged(this.mySelectedModuleName, source);
    }

    public void add(@NotNull ChangeListener listener, @NotNull Disposable parentDisposable) {
        this.myChangeEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    public PsProject getProject() {
        return this.myProject;
    }

    public void dispose() {
    }

    @NotNull
    public ProjectStructureConfigurable getMainConfigurable() {
        return ProjectStructureConfigurable.getInstance(this.myProject.getResolvedModel());
    }

    public static interface ChangeListener
    extends EventListener {
        public void moduleSelectionChanged(@NotNull String var1, @NotNull Object var2);
    }
}

