/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AndroidArtifactNode;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.PsDependencyComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.util.containers.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class DependencyNodes {
    private DependencyNodes() {
    }

    @NotNull
    static List<AbstractPsModelNode<?>> createNodesFor(@NotNull AndroidArtifactNode parent, @NotNull Collection<PsDependency> dependencies2) {
        ArrayList children = Lists.newArrayList();
        SortedList declared = new SortedList((Comparator)PsDependencyComparator.INSTANCE);
        HashMultimap allTransitive = HashMultimap.create();
        ArrayList mayBeTransitive = Lists.newArrayList();
        for (PsDependency dependency2 : dependencies2) {
            ImmutableCollection<DependencyModel> parsedModels = dependency2.getParsedModels();
            if (parsedModels.isEmpty()) {
                mayBeTransitive.add(dependency2);
                continue;
            }
            block1: for (DependencyModel parsedModel : parsedModels) {
                for (PsAndroidArtifact artifact : parent.getModels()) {
                    if (!artifact.contains(parsedModel)) continue;
                    declared.add(dependency2);
                    continue block1;
                }
            }
            DependencyNodes.addTransitive(dependency2, (Multimap<PsDependency, PsDependency>)allTransitive);
        }
        Collection uniqueTransitives = allTransitive.values();
        declared.addAll(mayBeTransitive.stream().filter(dependency -> !uniqueTransitives.contains(dependency)).collect(Collectors.toList()));
        for (PsDependency dependency3 : declared) {
            AbstractDependencyNode<?> child = AbstractDependencyNode.createNode(parent, dependency3);
            if (child == null) continue;
            children.add(child);
        }
        return children;
    }

    private static void addTransitive(@NotNull PsDependency dependency, @NotNull Multimap<PsDependency, PsDependency> allTransitive) {
        if (allTransitive.containsKey((Object)dependency)) {
            return;
        }
        if (dependency instanceof PsLibraryAndroidDependency) {
            PsLibraryAndroidDependency libraryDependency = (PsLibraryAndroidDependency)dependency;
            ImmutableCollection<PsDependency> transitives = libraryDependency.getTransitiveDependencies();
            allTransitive.putAll((Object)dependency, transitives);
            for (PsDependency transitive : transitives) {
                DependencyNodes.addTransitive(transitive, allTransitive);
            }
        }
    }
}

