/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview;

import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview.DependencyNodes;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AndroidArtifactNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.ArtifactComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.PsDependencyComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsResettableNode;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsDependencyContainer;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.util.containers.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResolvedDependenciesTreeRootNode
extends AbstractPsResettableNode<PsAndroidModule> {
    private boolean myGroupVariants;

    ResolvedDependenciesTreeRootNode(@NotNull PsAndroidModule module) {
        super(module);
        this.myGroupVariants = PsUISettings.getInstance().RESOLVED_DEPENDENCIES_GROUP_VARIANTS;
    }

    boolean settingsChanged() {
        if (PsUISettings.getInstance().RESOLVED_DEPENDENCIES_GROUP_VARIANTS != this.myGroupVariants) {
            this.myGroupVariants = PsUISettings.getInstance().RESOLVED_DEPENDENCIES_GROUP_VARIANTS;
            this.reset();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected List<? extends AbstractPsModelNode> createChildren() {
        HashMap variantsByName = Maps.newHashMap();
        for (PsAndroidModule module : this.getModels()) {
            module.forEachVariant(variant -> variantsByName.put(variant.getName(), variant));
        }
        PsAndroidModule androidModule = (PsAndroidModule)this.getModels().get(0);
        if (this.myGroupVariants) {
            return this.createGroupedChildren(androidModule, variantsByName);
        }
        return this.createChildren(androidModule, variantsByName);
    }

    @NotNull
    private List<? extends AbstractPsModelNode> createGroupedChildren(@NotNull PsAndroidModule module, @NotNull Map<String, PsVariant> variantsByName) {
        HashMap containersWithMainArtifactByVariant = Maps.newHashMap();
        Map<List<PsDependencyContainer>, List<PsDependency>> groupedDependencies = ResolvedDependenciesTreeRootNode.groupDependencies(module);
        block0: for (List<PsDependencyContainer> containers : groupedDependencies.keySet()) {
            for (PsDependencyContainer container : containers) {
                if (!container.getArtifact().endsWith("_main_")) continue;
                containersWithMainArtifactByVariant.put(container.getVariant(), containers);
                continue block0;
            }
        }
        ArrayList children = Lists.newArrayList();
        for (List<PsDependencyContainer> containers : groupedDependencies.keySet()) {
            AndroidArtifactNode mainArtifactNode;
            List<PsAndroidArtifact> groupArtifacts;
            block5: {
                block6: {
                    List mainArtifactContainers;
                    groupArtifacts = ResolvedDependenciesTreeRootNode.extractArtifacts(containers, variantsByName);
                    mainArtifactNode = null;
                    if (containersWithMainArtifactByVariant.values().contains(containers)) break block5;
                    if (containers.size() != 1) break block6;
                    PsDependencyContainer container = containers.get(0);
                    String variantName = container.getVariant();
                    PsVariant variant = variantsByName.get(variantName);
                    assert (variant != null);
                    PsAndroidArtifact mainArtifact = variant.findArtifact("_main_");
                    if (mainArtifact == null || (mainArtifactContainers = (List)containersWithMainArtifactByVariant.get(variantName)) == null) break block5;
                    List<PsDependency> mainArtifactDependencies = groupedDependencies.get(mainArtifactContainers);
                    mainArtifactNode = this.createArtifactNode(mainArtifact, mainArtifactDependencies, null);
                    break block5;
                }
                for (PsDependencyContainer container : containers) {
                    List mainArtifactContainers = (List)containersWithMainArtifactByVariant.get(container.getVariant());
                    if (mainArtifactContainers == null) continue;
                    List<PsAndroidArtifact> mainArtifacts = ResolvedDependenciesTreeRootNode.extractArtifacts(mainArtifactContainers, variantsByName);
                    mainArtifactNode = this.createArtifactNode(mainArtifacts, groupedDependencies.get(mainArtifactContainers), null);
                    break;
                }
            }
            Collections.sort(groupArtifacts, ArtifactComparator.INSTANCE);
            AndroidArtifactNode artifactNode = this.createArtifactNode(groupArtifacts, groupedDependencies.get(containers), mainArtifactNode);
            if (artifactNode == null) continue;
            children.add(artifactNode);
        }
        Collections.sort(children, (a1, a2) -> a1.getName().compareTo(a2.getName()));
        return children;
    }

    @VisibleForTesting
    @NotNull
    static Map<List<PsDependencyContainer>, List<PsDependency>> groupDependencies(@NotNull PsAndroidModule module) {
        HashMap dependenciesByContainer = Maps.newHashMap();
        HashMap containerWithMainArtifact = Maps.newHashMap();
        module.forEachDependency(dependency -> {
            Collection<PsDependencyContainer> containers = dependency.getContainers();
            for (PsDependencyContainer container : containers) {
                List containerDependencies;
                if (container.getArtifact().equals("_main_")) {
                    containerWithMainArtifact.put(container.getVariant(), container);
                }
                if ((containerDependencies = (List)dependenciesByContainer.get(container)) == null) {
                    containerDependencies = new SortedList((Comparator)PsDependencyComparator.INSTANCE);
                    dependenciesByContainer.put(container, containerDependencies);
                }
                containerDependencies.add(dependency);
            }
        });
        ArrayList containerGroups = Lists.newArrayList();
        ArrayList containers = Lists.newArrayList(dependenciesByContainer.keySet());
        ArrayList currentGroup = Lists.newArrayList();
        while (!containers.isEmpty()) {
            PsDependencyContainer container1 = (PsDependencyContainer)containers.get(0);
            currentGroup.add(container1);
            if (containers.size() > 1) {
                for (int i = 1; i < containers.size(); ++i) {
                    PsDependencyContainer container2 = (PsDependencyContainer)containers.get(i);
                    if (!ResolvedDependenciesTreeRootNode.haveSameDependencies(container1, container2, dependenciesByContainer)) continue;
                    if (containerWithMainArtifact.values().contains(container1)) {
                        currentGroup.add(container2);
                        continue;
                    }
                    PsDependencyContainer mainArtifactContainer1 = (PsDependencyContainer)containerWithMainArtifact.get(container1.getVariant());
                    PsDependencyContainer mainArtifactContainer2 = (PsDependencyContainer)containerWithMainArtifact.get(container2.getVariant());
                    if (mainArtifactContainer1 == null && mainArtifactContainer2 == null) {
                        currentGroup.add(container2);
                    }
                    if (mainArtifactContainer1 == null || mainArtifactContainer2 == null || !ResolvedDependenciesTreeRootNode.haveSameDependencies(mainArtifactContainer1, mainArtifactContainer2, dependenciesByContainer)) continue;
                    currentGroup.add(container2);
                }
            }
            containerGroups.add(currentGroup);
            containers.removeAll(currentGroup);
            currentGroup = Lists.newArrayList();
        }
        HashMap dependenciesByContainers = Maps.newHashMap();
        for (List group : containerGroups) {
            PsDependencyContainer container = (PsDependencyContainer)group.get(0);
            dependenciesByContainers.put(group, dependenciesByContainer.get(container));
        }
        return dependenciesByContainers;
    }

    private static boolean haveSameDependencies(@NotNull PsDependencyContainer c1, @NotNull PsDependencyContainer c2, @NotNull Map<PsDependencyContainer, List<PsDependency>> dependenciesByContainer) {
        if (c1.getArtifact().equals(c2.getArtifact())) {
            List<PsDependency> d1 = dependenciesByContainer.get(c1);
            List<PsDependency> d2 = dependenciesByContainer.get(c2);
            return d1.equals(d2);
        }
        return false;
    }

    @NotNull
    private static List<PsAndroidArtifact> extractArtifacts(@NotNull List<PsDependencyContainer> containers, @NotNull Map<String, PsVariant> variantsByName) {
        ArrayList groupArtifacts = Lists.newArrayList();
        for (PsDependencyContainer container : containers) {
            PsAndroidArtifact foundArtifact = ResolvedDependenciesTreeRootNode.extractArtifact(container, variantsByName);
            groupArtifacts.add(foundArtifact);
        }
        return groupArtifacts;
    }

    @Nullable
    private static PsAndroidArtifact extractArtifact(@NotNull PsDependencyContainer container, @NotNull Map<String, PsVariant> variantsByName) {
        PsVariant variant = variantsByName.get(container.getVariant());
        assert (variant != null);
        PsAndroidArtifact artifact = variant.findArtifact(container.getArtifact());
        assert (artifact != null);
        return artifact;
    }

    @Nullable
    private AndroidArtifactNode createArtifactNode(@NotNull List<PsAndroidArtifact> artifacts, @NotNull List<PsDependency> dependencies2, @Nullable AndroidArtifactNode mainArtifactNode) {
        if (!dependencies2.isEmpty() || mainArtifactNode != null) {
            AndroidArtifactNode artifactNode = new AndroidArtifactNode((AbstractPsNode)this, artifacts);
            ResolvedDependenciesTreeRootNode.populate(artifactNode, dependencies2, mainArtifactNode);
            return artifactNode;
        }
        return null;
    }

    @NotNull
    private List<? extends AndroidArtifactNode> createChildren(@NotNull PsAndroidModule module, @NotNull Map<String, PsVariant> variantsByName) {
        ArrayList childrenNodes = Lists.newArrayList();
        HashMap dependenciesByVariantAndArtifact = Maps.newHashMap();
        module.forEachDependency(dependency -> {
            if (!dependency.isDeclared()) {
                return;
            }
            for (PsDependencyContainer container : dependency.getContainers()) {
                List artifactDependencies;
                Map dependenciesByArtifact = (Map)dependenciesByVariantAndArtifact.get(container.getVariant());
                if (dependenciesByArtifact == null) {
                    dependenciesByArtifact = Maps.newHashMap();
                    dependenciesByVariantAndArtifact.put(container.getVariant(), dependenciesByArtifact);
                }
                if ((artifactDependencies = (List)dependenciesByArtifact.get(container.getArtifact())) == null) {
                    artifactDependencies = Lists.newArrayList();
                    dependenciesByArtifact.put(container.getArtifact(), artifactDependencies);
                }
                artifactDependencies.add(dependency);
            }
        });
        ArrayList variantNames = Lists.newArrayList(dependenciesByVariantAndArtifact.keySet());
        Collections.sort(variantNames);
        for (String variantName : variantNames) {
            PsVariant variant = variantsByName.get(variantName);
            Map dependenciesByArtifact = (Map)dependenciesByVariantAndArtifact.get(variantName);
            if (dependenciesByArtifact == null) continue;
            ArrayList artifactNames = Lists.newArrayList(dependenciesByArtifact.keySet());
            Collections.sort(artifactNames, ArtifactComparator.byName());
            for (String artifactName : artifactNames) {
                AndroidArtifactNode artifactNode;
                PsAndroidArtifact mainArtifact;
                PsAndroidArtifact artifact = variant.findArtifact(artifactName);
                assert (artifact != null);
                AndroidArtifactNode mainArtifactNode = null;
                String mainArtifactName = "_main_";
                if (!mainArtifactName.equals(artifactName) && (mainArtifact = variant.findArtifact(mainArtifactName)) != null) {
                    List<PsDependency> artifactDependencies = (List<PsDependency>)dependenciesByArtifact.get(mainArtifactName);
                    if (artifactDependencies == null) {
                        artifactDependencies = Collections.emptyList();
                    }
                    mainArtifactNode = this.createArtifactNode(mainArtifact, artifactDependencies, null);
                }
                if ((artifactNode = this.createArtifactNode(artifact, (List<PsDependency>)((List)dependenciesByArtifact.get(artifactName)), mainArtifactNode)) == null) continue;
                childrenNodes.add(artifactNode);
            }
        }
        return childrenNodes;
    }

    @Nullable
    private AndroidArtifactNode createArtifactNode(@NotNull PsAndroidArtifact artifact, @NotNull List<PsDependency> dependencies2, @Nullable AndroidArtifactNode mainArtifactNode) {
        if (!dependencies2.isEmpty() || mainArtifactNode != null) {
            AndroidArtifactNode artifactNode = new AndroidArtifactNode((AbstractPsNode)this, artifact);
            ResolvedDependenciesTreeRootNode.populate(artifactNode, dependencies2, mainArtifactNode);
            return artifactNode;
        }
        return null;
    }

    private static void populate(@NotNull AndroidArtifactNode artifactNode, @NotNull List<PsDependency> dependencies2, @Nullable AndroidArtifactNode mainArtifactNode) {
        List<AbstractPsModelNode<?>> children = DependencyNodes.createNodesFor(artifactNode, dependencies2);
        if (mainArtifactNode != null) {
            children.add(0, mainArtifactNode);
        }
        artifactNode.setChildren(children);
    }
}

