/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.treeview;

import com.intellij.util.containers.SortedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class Configuration
implements Comparable<Configuration> {
    @NotNull
    private final String myName;
    @NotNull
    private final Icon myIcon;
    @NotNull
    private final List<String> myTypes = new SortedList(String.CASE_INSENSITIVE_ORDER);

    Configuration(@NotNull String name, @NotNull Icon icon, boolean transitive) {
        this.myName = name;
        this.myIcon = icon;
        this.addType(transitive);
    }

    @NotNull
    String getName() {
        return this.myName;
    }

    @NotNull
    Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public List<String> getTypes() {
        return this.myTypes;
    }

    void addType(boolean transitive) {
        String type;
        String string = type = transitive ? "transitive" : "declared";
        if (!this.myTypes.contains(type)) {
            this.myTypes.add(type);
        }
    }

    @Override
    public int compareTo(Configuration other) {
        return this.myName.compareTo(other.myName);
    }
}

