/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview;

import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.google.common.collect.Lists;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPsNodeTreeBuilder
extends AbstractBaseTreeBuilder {
    public AbstractPsNodeTreeBuilder(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, @NotNull AbstractBaseTreeStructure treeStructure) {
        super(tree, treeModel, treeStructure);
    }

    @NotNull
    public <T extends AbstractPsModelNode<PsModel>> List<T> getMatchingSelection(@NotNull Class<T> nodeType) {
        Set selection = this.getSelectedElements(nodeType);
        if (!selection.isEmpty()) {
            AbstractPsModelNode first = (AbstractPsModelNode)((Object)ContainerUtil.getFirstItem((Collection)selection));
            assert (first != null);
            Object model = first.getFirstModel();
            ArrayList matchingSelection = Lists.newArrayList();
            for (AbstractPsModelNode node : selection) {
                if (!node.matches((PsModel)model)) {
                    return Collections.emptyList();
                }
                matchingSelection.add(node);
            }
            return matchingSelection;
        }
        return Collections.emptyList();
    }

    public void collectNodesMatchingCurrentSelection(@NotNull PsModel model, @NotNull MatchingNodeCollector collector) {
        this.collectMatchingNodes(model, collector, false, false);
    }

    public void selectNodesMatchingCurrentSelection() {
        PsModel model;
        AbstractPsModelNode<?> node = this.getSelectedNode();
        if (node != null && (model = AbstractPsNodeTreeBuilder.getFirstModel(node)) != null) {
            this.collectMatchingNodes(model, null, true, false);
        }
    }

    @Nullable
    public AbstractPsModelNode<?> getSelectedNode() {
        Object selection;
        Set selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 1 && (selection = ContainerUtil.getFirstItem((Collection)selectedElements)) instanceof AbstractPsModelNode) {
            return (AbstractPsModelNode)((Object)selection);
        }
        return null;
    }

    @Nullable
    private static PsModel getFirstModel(@NotNull AbstractPsModelNode<?> node) {
        List<?> models = node.getModels();
        Object model = models.get(0);
        if (model instanceof PsModel) {
            return (PsModel)model;
        }
        return null;
    }

    public void selectMatchingNodes(@NotNull PsModel model, boolean scroll) {
        this.collectMatchingNodes(model, null, true, scroll);
    }

    private void collectMatchingNodes(final @NotNull PsModel model, final @Nullable MatchingNodeCollector collector, boolean selectMatch, boolean scroll) {
        this.getInitialized().doWhenDone(() -> {
            final ArrayList toSelect = Lists.newArrayList();
            this.accept(AbstractPsModelNode.class, (TreeVisitor)new TreeVisitor<AbstractPsModelNode>(){

                public boolean visit(@NotNull AbstractPsModelNode node) {
                    if (node.matches(model)) {
                        toSelect.add(node);
                        if (collector != null) {
                            collector.onMatchingNodeFound(node);
                        }
                    }
                    return false;
                }
            });
            if (!selectMatch) {
                if (collector != null) {
                    collector.done(collector.matchingNodes);
                }
                return;
            }
            if (this.isDisposed()) {
                if (collector != null) {
                    collector.done(Collections.emptyList());
                }
                return;
            }
            Runnable onDone = () -> {
                this.expandParents(toSelect);
                if (collector != null) {
                    collector.done(collector.matchingNodes);
                }
                if (scroll) {
                    this.scrollToFirstSelectedRow();
                }
            };
            this.getUi().userSelect(toSelect.toArray(), (Runnable)new UserRunnable(onDone), false, false);
        });
    }

    public static abstract class MatchingNodeCollector {
        @NotNull
        final List<AbstractPsModelNode> matchingNodes = Lists.newArrayList();

        void onMatchingNodeFound(@NotNull AbstractPsModelNode node) {
            this.matchingNodes.add(node);
        }

        protected abstract void done(@NotNull List<AbstractPsModelNode> var1);
    }

    protected class UserRunnable
    implements Runnable {
        @Nullable
        private final Runnable myRunnable;

        public UserRunnable(Runnable runnable) {
            this.myRunnable = runnable;
        }

        @Override
        public void run() {
            if (this.myRunnable != null) {
                AbstractTreeUi treeUi = AbstractPsNodeTreeBuilder.this.getUi();
                if (treeUi != null) {
                    treeUi.executeUserRunnable(this.myRunnable);
                } else {
                    this.myRunnable.run();
                }
            }
        }
    }
}

