/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.issues;

import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.ui.CollapsiblePanel;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.navigation.Places;
import com.android.tools.idea.gradle.structure.quickfix.QuickFixes;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.BrowserUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.navigation.Place;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class IssuesViewer {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final IssuesRenderer myRenderer;
    private JBLabel myEmptyIssuesLabel;
    private JPanel myIssuesPanel1;
    private JPanel myIssuesPanel2;
    private JPanel myIssuesPanel3;
    private JPanel myIssuesPanel4;
    private JPanel myMainPanel;
    private JEditorPane myIssuesView1;
    private JEditorPane myIssuesView2;
    private JEditorPane myIssuesView3;
    private JEditorPane myIssuesView4;
    private boolean myShowEmptyText;

    public IssuesViewer(@NotNull PsContext context, @NotNull IssuesRenderer renderer) {
        this.myContext = context;
        this.myRenderer = renderer;
        this.$$$setupUI$$$();
    }

    public void display(@NotNull Collection<PsIssue> issues) {
        if (issues.isEmpty()) {
            if (this.myShowEmptyText) {
                this.myEmptyIssuesLabel.setVisible(true);
            }
            this.myIssuesPanel1.setVisible(false);
            this.myIssuesPanel2.setVisible(false);
            this.myIssuesPanel3.setVisible(false);
            this.myIssuesPanel4.setVisible(false);
            this.revalidateAndRepaintPanels();
            return;
        }
        this.myEmptyIssuesLabel.setVisible(false);
        this.myIssuesPanel1.setVisible(true);
        this.myIssuesPanel2.setVisible(true);
        this.myIssuesPanel3.setVisible(true);
        this.myIssuesPanel4.setVisible(true);
        HashMap issuesBySeverity = Maps.newHashMap();
        for (PsIssue issue2 : issues) {
            PsIssue.Severity severity = issue2.getSeverity();
            List currentIssues = (List)issuesBySeverity.get((Object)severity);
            if (currentIssues == null) {
                currentIssues = Lists.newArrayList();
                issuesBySeverity.put(severity, currentIssues);
            }
            currentIssues.add(issue2);
        }
        ArrayList severities = Lists.newArrayList(issuesBySeverity.keySet());
        Collections.sort(severities, (t1, t2) -> t1.getPriority() - t2.getPriority());
        int typeCount = severities.size();
        assert (typeCount < 5);
        int currentIssueIndex = typeCount - 1;
        PsIssue.Severity severity = (PsIssue.Severity)((Object)severities.get(currentIssueIndex));
        List group = (List)issuesBySeverity.get((Object)severity);
        IssuesViewer.updateTitle((CollapsiblePanel)this.myIssuesPanel4, severity, group);
        this.renderIssues(group, this.myIssuesView4);
        if (--currentIssueIndex < 0) {
            this.myIssuesPanel1.setVisible(false);
            this.myIssuesPanel2.setVisible(false);
            this.myIssuesPanel3.setVisible(false);
            this.revalidateAndRepaintPanels();
            return;
        }
        severity = (PsIssue.Severity)((Object)severities.get(currentIssueIndex));
        group = (List)issuesBySeverity.get((Object)severity);
        IssuesViewer.updateTitle((CollapsiblePanel)this.myIssuesPanel3, severity, group);
        this.renderIssues(group, this.myIssuesView3);
        if (--currentIssueIndex < 0) {
            this.myIssuesPanel1.setVisible(false);
            this.myIssuesPanel2.setVisible(false);
            this.revalidateAndRepaintPanels();
            return;
        }
        severity = (PsIssue.Severity)((Object)severities.get(currentIssueIndex));
        group = (List)issuesBySeverity.get((Object)severity);
        IssuesViewer.updateTitle((CollapsiblePanel)this.myIssuesPanel2, severity, group);
        this.renderIssues(group, this.myIssuesView2);
        if (--currentIssueIndex < 0) {
            this.myIssuesPanel1.setVisible(false);
            this.revalidateAndRepaintPanels();
            return;
        }
        severity = (PsIssue.Severity)((Object)severities.get(currentIssueIndex));
        group = (List)issuesBySeverity.get((Object)severity);
        IssuesViewer.updateTitle((CollapsiblePanel)this.myIssuesPanel1, severity, group);
        this.renderIssues(group, this.myIssuesView1);
        this.revalidateAndRepaintPanels();
    }

    private void renderIssues(@NotNull List<PsIssue> group, @NotNull JEditorPane view) {
        view.setText(this.myRenderer.render(group));
        view.setCaretPosition(0);
    }

    private void revalidateAndRepaintPanels() {
        UiUtil.revalidateAndRepaint(this.myIssuesPanel1);
        UiUtil.revalidateAndRepaint(this.myIssuesPanel2);
        UiUtil.revalidateAndRepaint(this.myIssuesPanel4);
        UiUtil.revalidateAndRepaint(this.myMainPanel);
    }

    private static void updateTitle(@NotNull CollapsiblePanel panel, @NotNull PsIssue.Severity severity, @NotNull List<PsIssue> issues) {
        SimpleColoredComponent title = panel.getTitleComponent();
        title.clear();
        title.setIcon(severity.getIcon());
        title.append(severity.getText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        int issueCount = issues.size();
        title.append(" (" + issueCount + (issueCount == 1 ? " item)" : " items)"), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @NotNull
    public JPanel getPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        Font font = UIUtil.getTreeFont();
        NavigationHyperlinkListener hyperlinkListener = new NavigationHyperlinkListener();
        this.myIssuesPanel1 = new CollapsiblePanel();
        this.myIssuesView1 = new JEditorPane();
        this.myIssuesView1.setFocusable(false);
        this.myIssuesView1.addHyperlinkListener((HyperlinkListener)((Object)hyperlinkListener));
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myIssuesView1, (Font)font);
        ((CollapsiblePanel)this.myIssuesPanel1).setContents(this.myIssuesView1);
        this.myIssuesPanel2 = new CollapsiblePanel();
        this.myIssuesView2 = new JEditorPane();
        this.myIssuesView2.setFocusable(false);
        this.myIssuesView2.addHyperlinkListener((HyperlinkListener)((Object)hyperlinkListener));
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myIssuesView2, (Font)font);
        ((CollapsiblePanel)this.myIssuesPanel2).setContents(this.myIssuesView2);
        this.myIssuesPanel3 = new CollapsiblePanel();
        this.myIssuesView3 = new JEditorPane();
        this.myIssuesView3.setFocusable(false);
        this.myIssuesView3.addHyperlinkListener((HyperlinkListener)((Object)hyperlinkListener));
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myIssuesView3, (Font)font);
        ((CollapsiblePanel)this.myIssuesPanel3).setContents(this.myIssuesView3);
        this.myIssuesPanel4 = new CollapsiblePanel();
        this.myIssuesView4 = new JEditorPane();
        this.myIssuesView4.setFocusable(false);
        this.myIssuesView4.addHyperlinkListener((HyperlinkListener)((Object)hyperlinkListener));
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myIssuesView4, (Font)font);
        ((CollapsiblePanel)this.myIssuesPanel4).setContents(this.myIssuesView4);
    }

    public void setShowEmptyText(boolean showEmptyText) {
        this.myShowEmptyText = showEmptyText;
        if (!this.myShowEmptyText) {
            this.myEmptyIssuesLabel.setVisible(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEmptyIssuesLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(0);
        jBLabel.setText("No messages to display");
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JPanel jPanel2 = this.myIssuesPanel4;
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel3 = this.myIssuesPanel2;
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = this.myIssuesPanel1;
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = this.myIssuesPanel3;
        jPanel.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class NavigationHyperlinkListener
    extends HyperlinkAdapter {
        private NavigationHyperlinkListener() {
        }

        protected void hyperlinkActivated(HyperlinkEvent e) {
            String target = e.getDescription();
            if (target.startsWith("psdGoTo://")) {
                String serializedPlace = target.substring("psdGoTo://".length());
                Place place = Places.deserialize(serializedPlace);
                ProjectStructureConfigurable mainConfigurable = IssuesViewer.this.myContext.getMainConfigurable();
                mainConfigurable.navigateTo(place, true);
                return;
            }
            if (target.startsWith("psdFix://")) {
                String quickFixPath = target.substring("psdFix://".length());
                QuickFixes.executeQuickFix(quickFixPath, IssuesViewer.this.myContext);
                return;
            }
            if (target.startsWith("https://") || target.startsWith("http://")) {
                BrowserUtil.browse((String)target);
            }
        }
    }
}

