/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.issues;

import com.android.tools.idea.gradle.structure.configurables.issues.IssuesRenderer;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SingleModuleIssuesRenderer
extends IssuesRenderer {
    @Override
    @NotNull
    public String render(@NotNull Collection<PsIssue> issues) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><body><ol>");
        for (PsIssue issue2 : issues) {
            String description;
            buffer.append("<li>").append(issue2.getText());
            PsPath quickFixPath = issue2.getQuickFixPath();
            if (quickFixPath != null) {
                buffer.append(" ").append(quickFixPath.toText(PsPath.TexType.HTML));
            }
            if (StringUtil.isNotEmpty((String)(description = issue2.getDescription()))) {
                buffer.append("<br/><br/>").append(description);
            }
            buffer.append("</li>");
        }
        buffer.append("</ol></body></html>");
        return buffer.toString();
    }
}

