/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.java.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.ModuleDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.SingleLibraryDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.issues.SingleModuleIssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.java.dependencies.DeclaredDependenciesTableModel;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.DeclaredDependenciesTableView;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaDependency;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MainPanel
extends AbstractDependenciesPanel {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final DeclaredDependenciesTableModel myDependenciesTableModel;
    @NotNull
    private final DeclaredDependenciesTableView<PsJavaDependency> myDependenciesTable;
    @NotNull
    private final String myPlaceName;

    MainPanel(@NotNull PsJavaModule module, @NotNull PsContext context) {
        super("Declared Dependencies", context, module);
        this.myContext = context;
        this.myContext.getAnalyzerDaemon().add((PsModel model) -> {
            if (model == module) {
                UIUtil.invokeLaterIfNeeded(this::updateDetailsAndIssues);
            }
        }, this);
        this.myPlaceName = MainPanel.createPlaceName(module.getName());
        this.getContentsPanel().add((Component)this.createActionsPanel(), "North");
        this.initializeDependencyDetails();
        this.setIssuesViewer(new IssuesViewer(this.myContext, new SingleModuleIssuesRenderer()));
        this.myDependenciesTableModel = new DeclaredDependenciesTableModel(module, this.myContext);
        this.myDependenciesTable = new DeclaredDependenciesTableView<PsJavaDependency>(this.myDependenciesTableModel, this.myContext);
        module.add((PsModule.DependencyChangedEvent event) -> {
            PsDependency dependency;
            this.myDependenciesTableModel.reset();
            PsJavaDependency toSelect = null;
            if (event instanceof PsModule.LibraryDependencyAddedEvent) {
                this.myDependenciesTable.clearSelection();
                PsArtifactDependencySpec spec = ((PsModule.LibraryDependencyAddedEvent)event).getSpec();
                toSelect = this.myDependenciesTableModel.findDependency(spec);
            } else if (event instanceof PsModule.DependencyModifiedEvent && (dependency = ((PsModule.DependencyModifiedEvent)event).getDependency()) instanceof PsJavaDependency) {
                toSelect = (PsJavaDependency)dependency;
            }
            if (toSelect != null) {
                this.myDependenciesTable.setSelection(Collections.singletonList(toSelect));
            }
        }, this);
        ListSelectionListener tableSelectionListener = e -> this.updateDetailsAndIssues();
        this.myDependenciesTable.getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.myDependenciesTable.selectFirstRow();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myDependenciesTable);
        scrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        this.getContentsPanel().add((Component)scrollPane, "Center");
        this.myDependenciesTable.updateColumnSizes();
    }

    @NotNull
    private static String createPlaceName(@NotNull String moduleName) {
        return "dependencies." + moduleName + ".place";
    }

    private void initializeDependencyDetails() {
        this.addDetails(new SingleLibraryDependencyDetails());
        this.addDetails(new ModuleDependencyDetails(this.getContext(), true));
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myDependenciesTable;
    }

    @Override
    @NotNull
    protected String getPlaceName() {
        return this.myPlaceName;
    }

    private void updateDetailsAndIssues() {
        PsJavaDependency selected = this.myDependenciesTable.getSelectionIfSingle();
        super.updateDetails(selected);
        this.updateIssues(selected);
        History history = this.getHistory();
        if (history != null) {
            history.pushQueryPlace();
        }
    }

    private void updateIssues(@Nullable PsJavaDependency selected) {
        List<PsIssue> issues = Collections.emptyList();
        if (selected != null) {
            issues = this.myContext.getAnalyzerDaemon().getIssues().findIssues(selected, null);
        }
        this.displayIssues(issues);
    }

    @Override
    public void selectDependency(@Nullable String dependency) {
        if (StringUtil.isEmpty((String)dependency)) {
            this.myDependenciesTable.requestFocusInWindow();
            this.myDependenciesTable.clearSelection();
            return;
        }
        this.doSelectDependency(dependency);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        String pathText;
        Object path;
        if (place != null && (path = place.getPath(this.myPlaceName)) instanceof String && !(pathText = (String)path).isEmpty()) {
            this.doSelectDependency(pathText);
        }
        return ActionCallback.DONE;
    }

    private void doSelectDependency(@NotNull String toSelect) {
        this.myDependenciesTable.selectDependency(toSelect);
    }

    public void dispose() {
        Disposer.dispose(this.myDependenciesTable);
    }
}

