/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.messages;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesByTypeAndTextComparator;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.daemon.PsAnalyzerDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.intellij.openapi.Disposable;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

class MessagesForm
implements Disposable {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final IssuesViewer myIssuesViewer;
    private int myMessageCount;
    private JPanel myMainPanel;
    private JPanel myContentsPanel;
    private JButton myCheckForUpdateButton;
    private JButton myAnalyzeProjectButton;

    MessagesForm(@NotNull PsContext context) {
        this.myContext = context;
        this.$$$setupUI$$$();
        this.myContext.getProject().forEachModule(module -> module.add(event -> {
            this.myContext.getAnalyzerDaemon().recreateUpdateIssues();
            this.analyzeProject();
        }, this));
        this.myIssuesViewer = new IssuesViewer(context, new IssuesRenderer());
        JPanel issuesViewerPanel = this.myIssuesViewer.getPanel();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)issuesViewerPanel, (int)20, (int)31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myContentsPanel.add((Component)scrollPane, "Center");
        this.renderIssues();
        this.myAnalyzeProjectButton.addActionListener(e -> this.analyzeProject());
        this.myCheckForUpdateButton.addActionListener(e -> {
            this.myCheckForUpdateButton.setEnabled(false);
            this.myContext.getAnalyzerDaemon().removeIssues(PsIssueType.LIBRARY_UPDATES_AVAILABLE);
            this.myContext.getLibraryUpdateCheckerDaemon().queueUpdateCheck();
        });
    }

    private void analyzeProject() {
        this.myAnalyzeProjectButton.setEnabled(false);
        PsAnalyzerDaemon daemon = this.myContext.getAnalyzerDaemon();
        daemon.removeIssues(PsIssueType.PROJECT_ANALYSIS);
        this.myContext.getProject().forEachModule(daemon::queueCheck);
    }

    private void enableButtons() {
        MessagesForm.enableButton(this.myAnalyzeProjectButton, this.myContext.getAnalyzerDaemon());
        MessagesForm.enableButton(this.myCheckForUpdateButton, this.myContext.getLibraryUpdateCheckerDaemon());
    }

    private static void enableButton(@NotNull JButton button, @NotNull PsDaemon daemon) {
        button.setEnabled(!daemon.isRunning());
    }

    void renderIssues() {
        this.enableButtons();
        List<PsIssue> issues = this.myContext.getAnalyzerDaemon().getIssues().getValues(PsModulePath.class);
        if (issues.size() > 1) {
            Collections.sort(issues, IssuesByTypeAndTextComparator.INSTANCE);
        }
        this.myMessageCount = issues.size();
        this.myIssuesViewer.display(issues);
    }

    @NotNull
    JPanel getPanel() {
        return this.myMainPanel;
    }

    int getMessageCount() {
        return this.myMessageCount;
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myContentsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2, 5, 5));
        jPanel.add((Component)jPanel3, "South");
        this.myAnalyzeProjectButton = jButton2 = new JButton();
        jButton2.setText("Analyze Project");
        jButton2.setMnemonic('A');
        jButton2.setDisplayedMnemonicIndex(0);
        Component component2 = jPanel3.add(jButton2);
        this.myCheckForUpdateButton = jButton = new JButton();
        jButton.setText("Check for Updates");
        jButton.setMnemonic('U');
        jButton.setDisplayedMnemonicIndex(10);
        Component component3 = jPanel3.add(jButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

