/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CollapsiblePanel
extends JPanel {
    @NotNull
    private final JPanel myPanel = new JPanel(new BorderLayout());
    @NotNull
    private final JBLabel myExpandButton;
    @NotNull
    private final SimpleColoredComponent myTitleComponent;
    @NotNull
    private final Icon myExpandedIcon;
    @NotNull
    private final Icon myCollapsedIcon;
    private JComponent myContents;
    private boolean myExpanded;

    public CollapsiblePanel() {
        this("");
    }

    public CollapsiblePanel(@NotNull String title) {
        super(new BorderLayout());
        this.add((Component)this.myPanel, "Center");
        this.myExpandButton = new JBLabel(" ");
        this.myExpandButton.setFocusable(false);
        this.myExpandButton.addMouseListener((MouseListener)new CollapseListener());
        this.myExpandedIcon = AllIcons.Nodes.TreeDownArrow;
        this.myCollapsedIcon = AllIcons.Nodes.TreeRightArrow;
        this.myTitleComponent = new SimpleColoredComponent();
        this.myTitleComponent.append(title, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        int iconTextGap = 5;
        this.myTitleComponent.setBorder(BorderFactory.createEmptyBorder(0, iconTextGap, 0, 0));
        JPanel expandPanel = new JPanel(new BorderLayout());
        expandPanel.add((Component)this.myExpandButton, "West");
        expandPanel.add((Component)this.myTitleComponent, "Center");
        int left = 4;
        expandPanel.setBorder(BorderFactory.createEmptyBorder(0, left, 0, 0));
        this.add((Component)expandPanel, "North");
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(10, 10 + this.myExpandedIcon.getIconWidth() + left + iconTextGap, 10, 10));
        this.setExpanded(true);
    }

    public void setContents(@NotNull JComponent contents) {
        if (this.myContents != null) {
            this.myPanel.remove(this.myContents);
        }
        this.myContents = contents;
        this.myPanel.add((Component)this.myContents, "Center");
        UiUtil.revalidateAndRepaint(this);
    }

    @NotNull
    public SimpleColoredComponent getTitleComponent() {
        return this.myTitleComponent;
    }

    @Override
    public String getToolTipText() {
        return this.myExpandButton.getToolTipText();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.myExpandButton.setToolTipText(toolTipText);
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public void setExpanded(boolean expanded) {
        boolean oldExpanded = this.myExpanded;
        if (oldExpanded != expanded) {
            this.myExpanded = expanded;
            Icon icon = this.myExpanded ? this.myExpandedIcon : this.myCollapsedIcon;
            this.myExpandButton.setIcon(icon);
            if (this.myExpanded) {
                this.add((Component)this.myPanel, "Center");
            } else {
                this.remove(this.myPanel);
            }
            UiUtil.revalidateAndRepaint(this);
            this.firePropertyChange("expanded", oldExpanded, expanded);
        }
    }

    private class CollapseListener
    extends MouseAdapter {
        private CollapseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            CollapsiblePanel.this.setExpanded(!CollapsiblePanel.this.myExpanded);
        }
    }
}

