/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.util.ui.LabeledComboBoxAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import icons.StudioIcons;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ModulesComboBoxAction
extends LabeledComboBoxAction {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final List<PsModule> myExtraTopModules;

    public ModulesComboBoxAction(@NotNull PsContext context, @NotNull List<PsModule> extraTopModules) {
        super("Module: ");
        this.myContext = context;
        this.myExtraTopModules = extraTopModules;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setIcon(StudioIcons.Shell.Filetree.ANDROID_MODULE);
        presentation.setText(this.myContext.getSelectedModule());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (PsModule module2 : this.myExtraTopModules) {
            group.add((AnAction)new ModuleAction(module2));
        }
        this.myContext.getProject().forEachModule(module -> group.add((AnAction)new ModuleAction((PsModule)module)));
        return group;
    }

    private class ModuleAction
    extends DumbAwareAction {
        @NotNull
        private final String myModuleName;

        ModuleAction(PsModule module) {
            super(module.getName(), "", module.getIcon());
            this.myModuleName = module.getName();
        }

        public void actionPerformed(AnActionEvent e) {
            ModulesComboBoxAction.this.myContext.setSelectedModule(this.myModuleName, (Object)this);
        }
    }
}

