/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModelAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyVersionQuickFixPath;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class PsModuleAnalyzer<T extends PsModule>
extends PsModelAnalyzer<T> {
    private static final Pattern URL_PATTERN = Pattern.compile("\\(?http://[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]");
    @NotNull
    private final PsContext myContext;

    protected PsModuleAnalyzer(@NotNull PsContext context) {
        this.myContext = context;
    }

    protected void analyzeDeclaredDependency(@NotNull PsLibraryDependency dependency, @NotNull PsModulePath modulePath, @NotNull PsIssueCollection issueCollection) {
        String message;
        PsArtifactDependencySpec resolvedSpec = dependency.getResolvedSpec();
        PsLibraryDependencyNavigationPath path = new PsLibraryDependencyNavigationPath(this.myContext, dependency);
        PsArtifactDependencySpec declaredSpec = dependency.getDeclaredSpec();
        assert (declaredSpec != null);
        String declaredVersion = declaredSpec.getVersion();
        if (declaredVersion != null && declaredVersion.endsWith("+")) {
            message = "Avoid using '+' in version numbers; can lead to unpredictable and unrepeatable builds.";
            PsIssue issue2 = new PsIssue(message, "", path, PsIssueType.PROJECT_ANALYSIS, PsIssue.Severity.WARNING);
            issue2.setExtraPath(modulePath);
            PsLibraryDependencyVersionQuickFixPath quickFix = new PsLibraryDependencyVersionQuickFixPath(dependency);
            issue2.setQuickFixPath(quickFix);
            issueCollection.add(issue2);
        }
        if (dependency.hasPromotedVersion()) {
            message = "Gradle promoted library version from " + declaredVersion + " to " + resolvedSpec.getVersion();
            String description = "To resolve version conflicts, Gradle by default uses the newest version of a dependency. <a href='https://docs.gradle.org/current/userguide/dependency_management.html'>Open Gradle documentation</a>";
            PsIssue issue3 = new PsIssue(message, description, path, PsIssueType.PROJECT_ANALYSIS, PsIssue.Severity.INFO);
            issue3.setExtraPath(modulePath);
            issueCollection.add(issue3);
        }
    }

    @NotNull
    protected PsContext getContext() {
        return this.myContext;
    }
}

