/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies;

import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.structure.dependencies.AbstractDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.dependencies.android.AndroidDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.dependencies.java.JavaDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAddDependenciesDialog
extends DialogWrapper {
    @NotNull
    private final PsModule myModule;
    private JPanel myMainPanel;
    private AbstractDependencyScopesPanel myScopesPanel;

    protected AbstractAddDependenciesDialog(@NotNull PsModule module) {
        super(module.getParent().getResolvedModel());
        this.myModule = module;
        this.init();
        this.getContentPanel().setBorder(BorderFactory.createEmptyBorder());
    }

    protected boolean postponeValidation() {
        return false;
    }

    @NotNull
    private static AbstractDependencyScopesPanel createDependencyScopesPanel(@NotNull PsModule module) {
        if (module instanceof PsAndroidModule) {
            return new AndroidDependencyScopesPanel((PsAndroidModule)module);
        }
        if (module instanceof PsJavaModule) {
            return new JavaDependencyScopesPanel((PsJavaModule)module);
        }
        throw new IllegalStateException("Unsupported module type: " + module.getClass().getName());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        if (this.myMainPanel == null) {
            this.myMainPanel = new JPanel(new BorderLayout());
            this.myScopesPanel = AbstractAddDependenciesDialog.createDependencyScopesPanel(this.myModule);
            JBSplitter splitter = new JBSplitter(true, this.getSplitterProportionKey(), 0.55f);
            splitter.setBorder(BorderFactory.createEmptyBorder());
            JComponent view = this.getDependencySelectionView();
            view.setBorder(AbstractAddDependenciesDialog.createMainPanelBorder());
            splitter.setFirstComponent(view);
            this.myScopesPanel.setBorder(AbstractAddDependenciesDialog.createMainPanelBorder());
            splitter.setSecondComponent((JComponent)this.myScopesPanel);
            this.myMainPanel.add((Component)splitter, "Center");
            this.myMainPanel.add((Component)new TitlePanel(this.myModule, this.getInstructions()), "North");
        }
        return this.myMainPanel;
    }

    @NotNull
    private static Border createMainPanelBorder() {
        return BorderFactory.createCompoundBorder((Border)new SideBorder(OnePixelDivider.BACKGROUND, 8), BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    @NotNull
    protected abstract String getSplitterProportionKey();

    @NotNull
    protected abstract JComponent getDependencySelectionView();

    @NotNull
    protected abstract String getInstructions();

    @NotNull
    protected PsModule getModule() {
        return this.myModule;
    }

    protected AbstractDependencyScopesPanel getScopesPanel() {
        return this.myScopesPanel;
    }

    public abstract void addNewDependencies();

    protected void dispose() {
        if (this.myScopesPanel != null) {
            Disposer.dispose((Disposable)this.myScopesPanel);
        }
        super.dispose();
    }

    private static class TitlePanel
    extends JPanel {
        TitlePanel(@NotNull PsModule module, @NotNull String instructions) {
            super(new BorderLayout());
            JBLabel titleLabel = new JBLabel();
            titleLabel.setFont(UIUtil.getButtonFont().deriveFont(1));
            titleLabel.setIcon(module.getIcon());
            titleLabel.setText(String.format("Module '%1$s'", module.getName()));
            this.add((Component)titleLabel, "North");
            JEditorPane instructionsPane = new JEditorPane();
            HtmlLabel.setUpAsHtmlLabel((JEditorPane)instructionsPane, (Font)UIUtil.getTreeFont());
            instructionsPane.setText("<html><body><b>Step 1.</b><br/>" + instructions + "</body></html>");
            instructionsPane.setBorder(BorderFactory.createEmptyBorder(8, 5, 0, 5));
            this.add((Component)instructionsPane, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
    }
}

