/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsArtifactDependencySpec {
    @NotNull
    private final String myName;
    @Nullable
    private final String myGroup;
    @Nullable
    private final String myVersion;
    private static final Pattern ourPattern = Pattern.compile("^(?:([^:@]*):)?([^\\d+:@][^:@]*)(?::([^:@]*))?(?::[^@]*)?(?:@.*)?$");

    @Nullable
    public static PsArtifactDependencySpec create(@NotNull String notation) {
        Matcher matcher = ourPattern.matcher(notation);
        if (!matcher.matches()) {
            return null;
        }
        return new PsArtifactDependencySpec(matcher.group(2), matcher.group(1), matcher.group(3));
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull ArtifactDependencyModel dependency) {
        return new PsArtifactDependencySpec(dependency.name().value(), (String)dependency.group().value(), (String)dependency.version().value());
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull GradleCoordinate coordinates) {
        return new PsArtifactDependencySpec(coordinates.getArtifactId(), coordinates.getGroupId(), coordinates.getRevision());
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull GradleModuleVersion moduleVersion) {
        return new PsArtifactDependencySpec(moduleVersion.getName(), moduleVersion.getGroup(), moduleVersion.getVersion());
    }

    public PsArtifactDependencySpec(@NotNull String name, @Nullable String group, @Nullable String version) {
        this.myName = name;
        this.myGroup = Strings.emptyToNull((String)group);
        this.myVersion = Strings.emptyToNull((String)version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsArtifactDependencySpec that = (PsArtifactDependencySpec)o;
        return Objects.equal((Object)this.myName, (Object)that.myName) && Objects.equal((Object)this.myGroup, (Object)that.myGroup) && Objects.equal((Object)this.myVersion, (Object)that.myVersion);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getGroup() {
        return this.myGroup;
    }

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myName, this.myGroup, this.myVersion});
    }

    public String toString() {
        return this.compactNotation();
    }

    @NotNull
    public String compactNotation() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.myGroup, this.myName, this.myVersion});
        return Joiner.on((String)":").skipNulls().join((Iterable)segments);
    }

    @NotNull
    public String getDisplayText() {
        boolean showGroupId = PsUISettings.getInstance().DECLARED_DEPENDENCIES_SHOW_GROUP_ID;
        StringBuilder text = new StringBuilder();
        if (showGroupId && StringUtil.isNotEmpty((String)this.myGroup)) {
            text.append(this.myGroup).append(":");
        }
        text.append(this.myName);
        if (StringUtil.isNotEmpty((String)this.myVersion)) {
            text.append(":").append(this.myVersion);
        }
        return text.toString();
    }
}

