/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.base.Objects;
import com.intellij.icons.AllIcons;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsIssue {
    @NotNull
    private final String myText;
    @NotNull
    private final PsPath myPath;
    @NotNull
    private final PsIssueType myType;
    @NotNull
    private final Severity mySeverity;
    @Nullable
    private final String myDescription;
    @Nullable
    private PsPath myExtraPath;
    @Nullable
    private PsPath myQuickFixPath;

    public PsIssue(@NotNull String text, @NotNull PsPath path, @NotNull PsIssueType type, @NotNull Severity severity) {
        this.myText = text;
        this.myPath = path;
        this.myType = type;
        this.mySeverity = severity;
        this.myDescription = null;
    }

    public PsIssue(@NotNull String text, @NotNull String description, @NotNull PsPath path, @NotNull PsIssueType type, @NotNull Severity severity) {
        this.myText = text;
        this.myDescription = description;
        this.myPath = path;
        this.myType = type;
        this.mySeverity = severity;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public Severity getSeverity() {
        return this.mySeverity;
    }

    @NotNull
    public PsPath getPath() {
        return this.myPath;
    }

    @Nullable
    public PsPath getExtraPath() {
        return this.myExtraPath;
    }

    public void setExtraPath(@Nullable PsPath extraPath) {
        this.myExtraPath = extraPath;
    }

    @Nullable
    public PsPath getQuickFixPath() {
        return this.myQuickFixPath;
    }

    public void setQuickFixPath(@Nullable PsPath quickFixPath) {
        this.myQuickFixPath = quickFixPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsIssue that = (PsIssue)o;
        return Objects.equal((Object)this.myText, (Object)that.myText) && Objects.equal((Object)this.myDescription, (Object)that.myDescription) && Objects.equal((Object)this.myPath, (Object)that.myPath) && Objects.equal((Object)this.myType, (Object)that.myType) && this.mySeverity == that.mySeverity;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myText, this.myDescription, this.myPath, this.myType, this.mySeverity});
    }

    public String toString() {
        return this.mySeverity.name() + ": " + this.myText;
    }

    @NotNull
    public PsIssueType getType() {
        return this.myType;
    }

    public static enum Severity {
        ERROR("Error", AllIcons.General.BalloonError, (Color)JBColor.RED, 0),
        WARNING("Warning", AllIcons.General.BalloonWarning, (Color)JBColor.YELLOW, 1),
        INFO("Information", AllIcons.General.BalloonInformation, (Color)JBColor.GRAY, 2),
        UPDATE("Update", AllIcons.Actions.Download, (Color)JBColor.GRAY, 3);

        @NotNull
        private final String myText;
        @NotNull
        private final Icon myIcon;
        @NotNull
        private final Color myColor;
        private final int myPriority;

        private Severity(@NotNull String text, Icon icon, Color color, int priority) {
            this.myText = text;
            this.myColor = color;
            this.myIcon = icon;
            this.myPriority = priority;
        }

        @NotNull
        public String getText() {
            return this.myText;
        }

        @NotNull
        public Icon getIcon() {
            return this.myIcon;
        }

        @NotNull
        public Color getColor() {
            return this.myColor;
        }

        public int getPriority() {
            return this.myPriority;
        }
    }
}

