/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesByTypeAndTextComparator;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsIssueCollection {
    @NotNull
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    @NotNull
    private final Multimap<PsPath, PsIssue> myIssues = HashMultimap.create();
    @NotNull
    private final PsContext myContext;

    public PsIssueCollection(@NotNull PsContext context) {
        this.myContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull PsIssue issue2) {
        PsPath path = issue2.getPath();
        PsPath extraPath = issue2.getExtraPath();
        Object object = this.myLock;
        synchronized (object) {
            this.myIssues.put((Object)path, (Object)issue2);
            if (extraPath != null) {
                this.myIssues.put((Object)extraPath, (Object)issue2);
            }
        }
    }

    @NotNull
    public List<PsIssue> findIssues(@NotNull PsModel model, @Nullable Comparator<PsIssue> comparator) {
        PsPath path = null;
        if (model instanceof PsModule) {
            PsModule module = (PsModule)model;
            path = new PsModulePath(module);
        }
        if (model instanceof PsLibraryDependency) {
            PsLibraryDependency dependency = (PsLibraryDependency)((Object)model);
            path = new PsLibraryDependencyNavigationPath(this.myContext, dependency);
        }
        if (path != null) {
            return this.findIssues(path, comparator);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<PsIssue> findIssues(@NotNull PsPath path, @Nullable Comparator<PsIssue> comparator) {
        ArrayList<PsIssue> issueList;
        Object object = this.myLock;
        synchronized (object) {
            issueList = new ArrayList<PsIssue>(this.myIssues.get((Object)path));
        }
        if (comparator != null && issueList.size() > 1) {
            Collections.sort(issueList, comparator);
        }
        return issueList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<PsIssue> getValues() {
        Object object = this.myLock;
        synchronized (object) {
            return new ArrayList<PsIssue>(this.myIssues.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<PsIssue> getValues(@NotNull Class<? extends PsPath> pathType) {
        HashSet issues = new HashSet();
        Object object = this.myLock;
        synchronized (object) {
            for (PsPath path : this.myIssues.keySet()) {
                if (!pathType.isInstance(path)) continue;
                issues.addAll(this.myIssues.get((Object)path));
            }
        }
        return new ArrayList<PsIssue>(issues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIssues.isEmpty();
        }
    }

    @Nullable
    public static String getTooltipText(@NotNull List<PsIssue> issues, boolean includePath) {
        if (issues.isEmpty()) {
            return null;
        }
        ArrayList<PsIssue> sorted = new ArrayList<PsIssue>(issues);
        Collections.sort(sorted, IssuesByTypeAndTextComparator.INSTANCE);
        boolean useBullets = issues.size() > 1;
        LinkedHashSet<String> lines = new LinkedHashSet<String>();
        for (PsIssue issue2 : sorted) {
            String path;
            String line = issue2.getText();
            if (includePath && !(path = issue2.getPath().toText(PsPath.TexType.PLAIN_TEXT)).isEmpty()) {
                line = path + ": " + line;
            }
            if (useBullets) {
                line = "<li>" + line + "</li>";
            }
            lines.add(line);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><body>");
        if (useBullets) {
            buffer.append("<ul>");
        }
        int issueCount = lines.size();
        int problems = 0;
        int count = 0;
        boolean tooManyMessages = false;
        for (String line : lines) {
            buffer.append(line);
            if (!useBullets) {
                buffer.append("<br>");
            }
            ++problems;
            if (count++ <= 9 || issueCount <= 12) continue;
            if (useBullets) {
                buffer.append("</ul>");
            }
            buffer.append(issueCount - problems).append(" more messages...<br>");
            tooManyMessages = true;
            break;
        }
        if (useBullets && !tooManyMessages) {
            buffer.append("</ul>");
        }
        buffer.append("</body></html>");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NotNull PsIssueType type) {
        Object object = this.myLock;
        synchronized (object) {
            Set paths = this.myIssues.keySet();
            ArrayList<Pair> toRemove = new ArrayList<Pair>();
            for (PsPath path : paths) {
                Collection issues = this.myIssues.get((Object)path);
                for (PsIssue issue2 : issues) {
                    if (!issue2.getType().equals(type)) continue;
                    toRemove.add(Pair.create((Object)path, (Object)issue2));
                }
            }
            for (Pair pair : toRemove) {
                this.myIssues.remove(pair.getFirst(), pair.getSecond());
            }
        }
    }
}

