/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsLibraryDependency
extends PsBaseDependency {
    @NotNull
    public PsModule getParent();

    @Nullable
    public PsArtifactDependencySpec getDeclaredSpec();

    public boolean hasPromotedVersion();

    @NotNull
    public ImmutableCollection<PsDependency> getTransitiveDependencies();

    default public void setVersion(@NotNull String version) {
        boolean modified = false;
        ArtifactDependencyModel reference = null;
        for (DependencyModel parsedDependency : this.getParsedModels()) {
            if (!(parsedDependency instanceof ArtifactDependencyModel)) continue;
            ArtifactDependencyModel dependency = (ArtifactDependencyModel)parsedDependency;
            dependency.setVersion(version);
            if (reference == null) {
                reference = dependency;
            }
            modified = true;
        }
        if (modified) {
            PsArtifactDependencySpec resolvedSpec;
            String resolvedVersion;
            GradleVersion parsedVersion = GradleVersion.parse((String)version);
            if (parsedVersion.compareTo(resolvedVersion = Strings.nullToEmpty((String)(resolvedSpec = this.getResolvedSpec()).getVersion())) != 0) {
                resolvedSpec = new PsArtifactDependencySpec(resolvedSpec.getName(), resolvedSpec.getGroup(), version);
                this.setResolvedSpec(resolvedSpec);
            }
            this.setDeclaredSpec(this.createSpec(reference));
            this.setModified(true);
            this.getParent().fireDependencyModifiedEvent((PsDependency)((Object)this));
        }
    }

    @NotNull
    public ImmutableCollection<DependencyModel> getParsedModels();

    @NotNull
    public PsArtifactDependencySpec getResolvedSpec();

    @NotNull
    default public PsArtifactDependencySpec createSpec(@NotNull ArtifactDependencyModel parsedModel) {
        String compactNotation = parsedModel.compactNotation().value();
        PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(compactNotation);
        if (!1.$assertionsDisabled && spec == null) {
            throw new AssertionError();
        }
        return spec;
    }

    public void setResolvedSpec(@NotNull PsArtifactDependencySpec var1);

    public void setDeclaredSpec(@NotNull PsArtifactDependencySpec var1);

    public void setModified(boolean var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

