/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterDefaultRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenCentralRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoryModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsChildModel;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsParsedDependencies;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.JCenterRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.MavenCentralRepository;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.util.EventDispatcher;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsModule
extends PsChildModel {
    @Nullable
    private String myGradlePath;
    @Nullable
    private final Module myResolvedModel;
    private GradleBuildModel myParsedModel;
    private String myModuleName;
    private PsParsedDependencies myParsedDependencies;
    private final EventDispatcher<DependenciesChangeListener> myDependenciesChangeEventDispatcher = EventDispatcher.create(DependenciesChangeListener.class);

    protected PsModule(@NotNull PsProject parent, @NotNull Module resolvedModel, @NotNull String gradlePath) {
        super(parent);
        this.myResolvedModel = resolvedModel;
        this.myGradlePath = gradlePath;
        this.myModuleName = resolvedModel.getName();
        this.myParsedModel = GradleBuildModel.get(this.myResolvedModel);
    }

    protected PsModule(@NotNull PsProject parent, @NotNull String name) {
        super(parent);
        this.myResolvedModel = null;
        this.myModuleName = name;
    }

    @Override
    @NotNull
    public PsProject getParent() {
        return (PsProject)super.getParent();
    }

    @Override
    @NotNull
    public String getName() {
        return this.myModuleName;
    }

    @Override
    public boolean isDeclared() {
        return this.myParsedModel != null;
    }

    @NotNull
    public PsParsedDependencies getParsedDependencies() {
        return this.myParsedDependencies == null ? (this.myParsedDependencies = new PsParsedDependencies(this.getParsedModel())) : this.myParsedDependencies;
    }

    @Nullable
    public GradleBuildModel getParsedModel() {
        return this.myParsedModel;
    }

    protected void addLibraryDependencyToParsedModel(@NotNull List<String> configurationNames, @NotNull String compactNotation) {
        GradleBuildModel parsedModel = this.getParsedModel();
        if (parsedModel != null) {
            DependenciesModel dependencies2 = parsedModel.dependencies();
            configurationNames.forEach(configurationName -> dependencies2.addArtifact((String)configurationName, compactNotation));
            this.getParsedDependencies().reset(this.getParsedModel());
        }
    }

    public void add(@NotNull DependenciesChangeListener listener, @NotNull Disposable parentDisposable) {
        this.myDependenciesChangeEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    protected void fireLibraryDependencyAddedEvent(@NotNull PsArtifactDependencySpec spec) {
        ((DependenciesChangeListener)this.myDependenciesChangeEventDispatcher.getMulticaster()).dependencyChanged(new LibraryDependencyAddedEvent(spec));
    }

    public void fireDependencyModifiedEvent(@NotNull PsDependency dependency) {
        ((DependenciesChangeListener)this.myDependenciesChangeEventDispatcher.getMulticaster()).dependencyChanged(new DependencyModifiedEvent(dependency));
    }

    @Nullable
    public String getGradlePath() {
        return this.myGradlePath;
    }

    @Nullable
    public Module getResolvedModel() {
        return this.myResolvedModel;
    }

    @Override
    public Icon getIcon() {
        return StudioIcons.Shell.Filetree.ANDROID_MODULE;
    }

    @NotNull
    public List<ArtifactRepository> getArtifactRepositories() {
        ArrayList repositories = Lists.newArrayList();
        this.populateRepositories(repositories);
        return repositories;
    }

    protected final void populateRepositories(@NotNull List<ArtifactRepository> repositories) {
        GradleBuildModel parsedModel = this.getParsedModel();
        if (parsedModel != null) {
            for (RepositoryModel repositoryModel : parsedModel.repositories().repositories()) {
                if (repositoryModel instanceof JCenterDefaultRepositoryModel) {
                    repositories.add(new JCenterRepository());
                    continue;
                }
                if (!(repositoryModel instanceof MavenCentralRepositoryModel)) continue;
                repositories.add(new MavenCentralRepository());
            }
        }
    }

    public boolean canDependOn(@NotNull PsModule module) {
        return false;
    }

    public static class DependencyModifiedEvent
    implements DependencyChangedEvent {
        @NotNull
        private final PsDependency myDependency;

        DependencyModifiedEvent(@NotNull PsDependency dependency) {
            this.myDependency = dependency;
        }

        @NotNull
        public PsDependency getDependency() {
            return this.myDependency;
        }
    }

    public static class LibraryDependencyAddedEvent
    implements DependencyChangedEvent {
        @NotNull
        private final PsArtifactDependencySpec mySpec;

        LibraryDependencyAddedEvent(@NotNull PsArtifactDependencySpec spec) {
            this.mySpec = spec;
        }

        @NotNull
        public PsArtifactDependencySpec getSpec() {
            return this.mySpec;
        }
    }

    public static interface DependencyChangedEvent {
    }

    public static interface DependenciesChangeListener
    extends EventListener {
        public void dependencyChanged(@NotNull DependencyChangedEvent var1);
    }
}

