/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsParsedDependencies {
    @NotNull
    private final Multimap<String, ModuleDependencyModel> myParsedModuleDependencies = ArrayListMultimap.create();
    @NotNull
    private final Multimap<String, ArtifactDependencyModel> myParsedArtifactDependencies = ArrayListMultimap.create();

    public PsParsedDependencies(@Nullable GradleBuildModel parsedModel) {
        this.reset(parsedModel);
    }

    void reset(@Nullable GradleBuildModel parsedModel) {
        this.myParsedArtifactDependencies.clear();
        this.myParsedModuleDependencies.clear();
        if (parsedModel != null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                for (DependencyModel parsedDependency : parsedModel.dependencies().all()) {
                    if (parsedDependency instanceof ArtifactDependencyModel) {
                        ArtifactDependencyModel artifact = (ArtifactDependencyModel)parsedDependency;
                        this.myParsedArtifactDependencies.put((Object)PsParsedDependencies.createIdFrom(artifact), (Object)artifact);
                        continue;
                    }
                    if (!(parsedDependency instanceof ModuleDependencyModel)) continue;
                    ModuleDependencyModel module = (ModuleDependencyModel)parsedDependency;
                    this.myParsedModuleDependencies.put((Object)module.path().value(), (Object)module);
                }
            });
        }
    }

    @NotNull
    private static String createIdFrom(@NotNull ArtifactDependencyModel dependency) {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{(String)dependency.group().value(), dependency.name().value()});
        return PsParsedDependencies.joinAsGradlePath(segments);
    }

    @NotNull
    public List<ArtifactDependencyModel> findLibraryDependencies(@NotNull PsArtifactDependencySpec spec, @Nullable Predicate<ArtifactDependencyModel> predicate) {
        String id = PsParsedDependencies.createIdFrom(spec);
        Collection potentialMatches = this.myParsedArtifactDependencies.get((Object)id);
        if (predicate != null) {
            return potentialMatches.stream().filter(predicate).collect(Collectors.toList());
        }
        return ImmutableList.copyOf((Collection)potentialMatches);
    }

    @NotNull
    private static String createIdFrom(@NotNull PsArtifactDependencySpec spec) {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{spec.getGroup(), spec.getName()});
        return PsParsedDependencies.joinAsGradlePath(segments);
    }

    @Nullable
    public ArtifactDependencyModel findLibraryDependency(@NotNull GradleCoordinate coordinates, @NotNull Predicate<ArtifactDependencyModel> predicate) {
        Collection potentialMatches = this.myParsedArtifactDependencies.get((Object)PsParsedDependencies.createIdFrom(coordinates));
        for (ArtifactDependencyModel dependency : potentialMatches) {
            if (!predicate.test(dependency)) continue;
            return dependency;
        }
        return null;
    }

    @NotNull
    private static String createIdFrom(@NotNull GradleCoordinate coordinates) {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{coordinates.getGroupId(), coordinates.getArtifactId()});
        return PsParsedDependencies.joinAsGradlePath(segments);
    }

    @Nullable
    public ArtifactDependencyModel findLibraryDependency(@NotNull GradleModuleVersion moduleVersion) {
        GradleVersion parsedVersion;
        Collection potentialMatches = this.myParsedArtifactDependencies.get((Object)PsParsedDependencies.createIdFrom(moduleVersion));
        if (potentialMatches.size() == 1) {
            return (ArtifactDependencyModel)ContainerUtil.getFirstItem((Collection)potentialMatches);
        }
        String version = Strings.nullToEmpty((String)moduleVersion.getVersion());
        HashMap dependenciesByVersion = Maps.newHashMap();
        for (ArtifactDependencyModel potentialMatch : potentialMatches) {
            GradleVersion parsedVersion2;
            String potentialVersion = Strings.nullToEmpty((String)((String)potentialMatch.version().value()));
            if (version.equals(potentialVersion)) {
                return potentialMatch;
            }
            if (!StringUtil.isNotEmpty((String)potentialVersion) || (parsedVersion2 = GradleVersion.tryParse((String)potentialVersion)) == null) continue;
            dependenciesByVersion.put(parsedVersion2, potentialMatch);
        }
        if (StringUtil.isNotEmpty((String)version) && !dependenciesByVersion.isEmpty() && (parsedVersion = GradleVersion.tryParse((String)version)) != null) {
            for (String potentialVersion : dependenciesByVersion.keySet()) {
                if (parsedVersion.compareTo((GradleVersion)potentialVersion) <= 0) continue;
                return (ArtifactDependencyModel)dependenciesByVersion.get(potentialVersion);
            }
        }
        return null;
    }

    @NotNull
    private static String createIdFrom(@NotNull GradleModuleVersion moduleVersion) {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{moduleVersion.getGroup(), moduleVersion.getName()});
        return PsParsedDependencies.joinAsGradlePath(segments);
    }

    @NotNull
    private static String joinAsGradlePath(@NotNull List<String> segments) {
        return Joiner.on((String)":").skipNulls().join(segments);
    }

    @Nullable
    public ModuleDependencyModel findModuleDependency(@NotNull String gradlePath, @NotNull Predicate<ModuleDependencyModel> predicate) {
        Collection potentialMatches = this.myParsedModuleDependencies.get((Object)gradlePath);
        for (ModuleDependencyModel dependency : potentialMatches) {
            if (!predicate.test(dependency)) continue;
            return dependency;
        }
        return null;
    }
}

