/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.JavaArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsAndroidArtifactCollection
implements PsModelCollection<PsAndroidArtifact> {
    @NotNull
    private final PsVariant myParent;
    @NotNull
    private final Map<String, PsAndroidArtifact> myArtifactsByName = Maps.newHashMap();

    PsAndroidArtifactCollection(@NotNull PsVariant parent) {
        this.myParent = parent;
        IdeVariant variant = this.myParent.getResolvedModel();
        if (variant != null) {
            this.addArtifact(variant.getMainArtifact());
            for (AndroidArtifact androidArtifact : variant.getExtraAndroidArtifacts()) {
                if (androidArtifact == null) continue;
                this.addArtifact((IdeAndroidArtifact)androidArtifact);
            }
            for (JavaArtifact javaArtifact : variant.getExtraJavaArtifacts()) {
                if (javaArtifact == null) continue;
                this.addArtifact((IdeJavaArtifact)javaArtifact);
            }
        }
    }

    private void addArtifacts(@NotNull Collection<? extends IdeBaseArtifact> artifacts) {
        artifacts.forEach(this::addArtifact);
    }

    private void addArtifact(@NotNull IdeBaseArtifact artifact) {
        this.myArtifactsByName.put(artifact.getName(), new PsAndroidArtifact(this.myParent, artifact.getName(), artifact));
    }

    @Override
    @Nullable
    public <S extends PsAndroidArtifact> S findElement(@NotNull String name, @NotNull Class<S> type) {
        PsAndroidArtifact found = this.myArtifactsByName.get(name);
        return (S)(type.isInstance(found) ? (PsAndroidArtifact)type.cast(found) : null);
    }

    @Override
    public void forEach(@NotNull Consumer<PsAndroidArtifact> consumer) {
        this.myArtifactsByName.values().forEach(consumer);
    }

    @NotNull
    public PsVariant getParent() {
        return this.myParent;
    }
}

