/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.level2.Library;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.util.PlatformIcons;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsLibraryAndroidDependency
extends PsAndroidDependency
implements PsLibraryDependency {
    @NotNull
    private final List<PsArtifactDependencySpec> myPomDependencies = Lists.newArrayList();
    @NotNull
    private final Set<String> myTransitiveDependencies = Sets.newHashSet();
    @NotNull
    private PsArtifactDependencySpec myResolvedSpec;
    @Nullable
    private final Library myResolvedModel;
    @Nullable
    private PsArtifactDependencySpec myDeclaredSpec;

    PsLibraryAndroidDependency(@NotNull PsAndroidModule parent, @NotNull PsArtifactDependencySpec resolvedSpec, @NotNull PsAndroidArtifact container, @Nullable Library resolvedModel, @Nullable ArtifactDependencyModel parsedModel) {
        super(parent, container, parsedModel);
        this.myResolvedSpec = resolvedSpec;
        this.myResolvedModel = resolvedModel;
        if (parsedModel != null) {
            this.setDeclaredSpec(this.createSpec(parsedModel));
        }
    }

    @Nullable
    public Library getResolvedModel() {
        return this.myResolvedModel;
    }

    void addTransitiveDependency(@NotNull String dependency) {
        this.myTransitiveDependencies.add(dependency);
    }

    void setDependenciesFromPomFile(@NotNull List<PsArtifactDependencySpec> pomDependencies) {
        this.myPomDependencies.clear();
        this.myPomDependencies.addAll(pomDependencies);
    }

    @Override
    @NotNull
    public ImmutableCollection<PsDependency> getTransitiveDependencies() {
        PsLibraryAndroidDependency found;
        PsModule module = this.getParent();
        ImmutableSet.Builder transitive = ImmutableSet.builder();
        for (String string : this.myTransitiveDependencies) {
            found = ((PsAndroidModule)module).findLibraryDependency(string);
            if (found == null) continue;
            transitive.add((Object)found);
        }
        for (PsArtifactDependencySpec psArtifactDependencySpec : this.myPomDependencies) {
            found = ((PsAndroidModule)module).findLibraryDependency(psArtifactDependencySpec);
            if (found == null) continue;
            transitive.add((Object)found);
        }
        return transitive.build();
    }

    @Override
    public void addParsedModel(@NotNull DependencyModel parsedModel) {
        assert (parsedModel instanceof ArtifactDependencyModel);
        if (this.getParsedModels().isEmpty()) {
            this.myDeclaredSpec = PsArtifactDependencySpec.create((ArtifactDependencyModel)parsedModel);
        }
        super.addParsedModel(parsedModel);
    }

    @Override
    @Nullable
    public PsArtifactDependencySpec getDeclaredSpec() {
        return this.myDeclaredSpec;
    }

    @Override
    @NotNull
    public PsArtifactDependencySpec getResolvedSpec() {
        return this.myResolvedSpec;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myResolvedSpec.getName();
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return PlatformIcons.LIBRARY_ICON;
    }

    @Override
    @NotNull
    public String toText(@NotNull PsDependency.TextType type) {
        switch (type) {
            case PLAIN_TEXT: {
                return this.myResolvedSpec.toString();
            }
            case FOR_NAVIGATION: {
                PsArtifactDependencySpec spec = this.myDeclaredSpec;
                if (spec == null) {
                    spec = this.myResolvedSpec;
                }
                return spec.toString();
            }
        }
        return "";
    }

    @Override
    public boolean hasPromotedVersion() {
        if (this.myResolvedSpec.getVersion() != null && this.myDeclaredSpec != null && this.myDeclaredSpec.getVersion() != null) {
            GradleVersion declaredVersion = GradleVersion.tryParse((String)this.myDeclaredSpec.getVersion());
            return declaredVersion != null && declaredVersion.compareTo(this.myResolvedSpec.getVersion()) < 0;
        }
        return false;
    }

    @Override
    public void setResolvedSpec(@NotNull PsArtifactDependencySpec spec) {
        this.myResolvedSpec = spec;
    }

    @Override
    public void setDeclaredSpec(@NotNull PsArtifactDependencySpec spec) {
        this.myDeclaredSpec = spec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsLibraryAndroidDependency that = (PsLibraryAndroidDependency)o;
        return Objects.equals(this.myResolvedSpec, that.myResolvedSpec);
    }

    public int hashCode() {
        return Objects.hash(this.myDeclaredSpec);
    }

    @Override
    public String toString() {
        return this.toText(PsDependency.TextType.PLAIN_TEXT);
    }
}

