/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.android.ProductFlavorModel;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsProductFlavorCollection
implements PsModelCollection<PsProductFlavor> {
    @NotNull
    private final Map<String, PsProductFlavor> myProductFlavorsByName = Maps.newHashMap();

    PsProductFlavorCollection(PsAndroidModule parent) {
        AndroidModel android;
        HashMap productFlavorsFromGradle = Maps.newHashMap();
        for (ProductFlavorContainer container : parent.getGradleModel().getAndroidProject().getProductFlavors()) {
            ProductFlavor productFlavor = container.getProductFlavor();
            productFlavorsFromGradle.put(productFlavor.getName(), productFlavor);
        }
        GradleBuildModel parsedModel = parent.getParsedModel();
        if (parsedModel != null && (android = parsedModel.android()) != null) {
            List<ProductFlavorModel> parsedProductFlavors = android.productFlavors();
            for (ProductFlavorModel parsedProductFlavor : parsedProductFlavors) {
                String name = parsedProductFlavor.name();
                ProductFlavor fromGradle = (ProductFlavor)productFlavorsFromGradle.remove(name);
                PsProductFlavor model = new PsProductFlavor(parent, fromGradle, parsedProductFlavor);
                this.myProductFlavorsByName.put(name, model);
            }
        }
        if (!productFlavorsFromGradle.isEmpty()) {
            for (ProductFlavor productFlavor : productFlavorsFromGradle.values()) {
                PsProductFlavor model = new PsProductFlavor(parent, productFlavor, null);
                this.myProductFlavorsByName.put(productFlavor.getName(), model);
            }
        }
    }

    @Override
    public void forEach(@NotNull Consumer<PsProductFlavor> consumer) {
        this.myProductFlavorsByName.values().forEach(consumer);
    }

    @Override
    @Nullable
    public <S extends PsProductFlavor> S findElement(@NotNull String name, @NotNull Class<S> type) {
        if (PsProductFlavor.class.equals(type)) {
            return (S)((PsProductFlavor)type.cast(this.myProductFlavorsByName.get(name)));
        }
        return null;
    }
}

