/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsVariantCollection
implements PsModelCollection<PsVariant> {
    @NotNull
    private final Map<String, PsVariant> myVariantsByName = Maps.newHashMap();

    PsVariantCollection(@NotNull PsAndroidModule parent) {
        parent.getGradleModel().getAndroidProject().forEachVariant(ideVariant -> {
            ArrayList productFlavors = Lists.newArrayList();
            for (String productFlavorName : ideVariant.getProductFlavors()) {
                PsProductFlavor productFlavor = parent.findProductFlavor(productFlavorName);
                if (productFlavor == null) continue;
                productFlavors.add(productFlavor.getName());
            }
            String buildType = ideVariant.getBuildType();
            PsVariant variant = new PsVariant(parent, ideVariant.getName(), buildType, productFlavors, (IdeVariant)ideVariant);
            this.myVariantsByName.put(ideVariant.getName(), variant);
        });
    }

    @Override
    @Nullable
    public <S extends PsVariant> S findElement(@NotNull String name, @NotNull Class<S> type) {
        PsVariant found = this.myVariantsByName.get(name);
        return (S)(type.isInstance(found) ? (PsVariant)type.cast(found) : null);
    }

    @Override
    public void forEach(@NotNull Consumer<PsVariant> consumer) {
        this.myVariantsByName.values().forEach(consumer);
    }
}

