/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.java;

import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModelCollection;
import com.android.tools.idea.gradle.structure.model.PsParsedDependencies;
import com.android.tools.idea.gradle.structure.model.java.PsJavaDependency;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.android.tools.idea.gradle.structure.model.java.PsLibraryJavaDependency;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsJavaDependencyCollection
implements PsModelCollection<PsJavaDependency> {
    @NotNull
    private final PsJavaModule myParent;
    @NotNull
    private final Map<String, PsLibraryJavaDependency> myLibraryDependenciesBySpec = Maps.newHashMap();

    PsJavaDependencyCollection(@NotNull PsJavaModule parent) {
        this.myParent = parent;
        this.addDependencies();
    }

    private void addDependencies() {
        PsParsedDependencies parsedDependencies = this.myParent.getParsedDependencies();
        JavaModuleModel gradleModel = this.myParent.getGradleModel();
        for (JarLibraryDependency libraryDependency : gradleModel.getJarLibraryDependencies()) {
            GradleModuleVersion moduleVersion = libraryDependency.getModuleVersion();
            if (moduleVersion == null) continue;
            PsArtifactDependencySpec spec = PsArtifactDependencySpec.create(moduleVersion);
            ArtifactDependencyModel parsed = parsedDependencies.findLibraryDependency(moduleVersion);
            PsLibraryJavaDependency dependency = new PsLibraryJavaDependency(this.myParent, spec, libraryDependency, parsed);
            this.myLibraryDependenciesBySpec.put(spec.toString(), dependency);
        }
    }

    @Override
    @Nullable
    public <S extends PsJavaDependency> S findElement(@NotNull String name, @NotNull Class<S> type) {
        return null;
    }

    @Override
    public void forEach(@NotNull Consumer<PsJavaDependency> consumer) {
        PsJavaDependencyCollection.forEachDependency(this.myLibraryDependenciesBySpec, consumer);
    }

    private static void forEachDependency(@NotNull Map<String, ? extends PsJavaDependency> dependenciesBySpec, @NotNull Consumer<PsJavaDependency> consumer) {
        dependenciesBySpec.values().forEach(consumer);
    }

    void forEachDeclaredDependency(@NotNull Consumer<PsJavaDependency> consumer) {
        PsJavaDependencyCollection.forEachDeclaredDependency(this.myLibraryDependenciesBySpec, consumer);
    }

    private static void forEachDeclaredDependency(@NotNull Map<String, ? extends PsJavaDependency> dependenciesBySpec, @NotNull Consumer<PsJavaDependency> consumer) {
        dependenciesBySpec.values().stream().filter(PsDependency::isDeclared).forEach(consumer);
    }

    void addLibraryDependency(@NotNull PsArtifactDependencySpec spec, @Nullable ArtifactDependencyModel parsedModel) {
        PsLibraryJavaDependency dependency = this.myLibraryDependenciesBySpec.get(spec.toString());
        if (dependency == null) {
            dependency = new PsLibraryJavaDependency(this.myParent, spec, null, parsedModel);
            this.myLibraryDependenciesBySpec.put(spec.toString(), dependency);
        } else {
            PsJavaDependencyCollection.updateDependency(dependency, parsedModel);
        }
    }

    private static void updateDependency(@NotNull PsJavaDependency dependency, @Nullable DependencyModel parsedModel) {
        if (parsedModel != null) {
            dependency.addParsedModel(parsedModel);
        }
    }
}

