/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FoundArtifact
implements Comparable<FoundArtifact> {
    @NotNull
    private final String myRepositoryName;
    @NotNull
    private final String myGroupId;
    @NotNull
    private final String myName;
    @NotNull
    private final List<GradleVersion> myVersions = Lists.newArrayList();

    FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name, @NotNull GradleVersion version) {
        this(repositoryName, groupId, name);
        this.myVersions.add(version);
        this.sortVersionsFromNewestToOldest();
    }

    FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name, @NotNull List<GradleVersion> versions) {
        this(repositoryName, groupId, name);
        this.myVersions.addAll(versions);
        this.sortVersionsFromNewestToOldest();
    }

    private void sortVersionsFromNewestToOldest() {
        if (this.myVersions.size() > 1) {
            Collections.sort(this.myVersions, Collections.reverseOrder());
        }
    }

    private FoundArtifact(@NotNull String repositoryName, @NotNull String groupId, @NotNull String name) {
        this.myRepositoryName = repositoryName;
        this.myGroupId = groupId;
        this.myName = name;
    }

    @NotNull
    public String getRepositoryName() {
        return this.myRepositoryName;
    }

    @NotNull
    public String getGroupId() {
        return this.myGroupId;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<GradleVersion> getVersions() {
        return this.myVersions;
    }

    @Override
    public int compareTo(FoundArtifact other) {
        int compare = FoundArtifact.comparePrioritizedStrings(this.myRepositoryName, other.myRepositoryName, FoundArtifact::getRepositoryPriority);
        if (compare != 0) {
            return compare;
        }
        compare = FoundArtifact.comparePrioritizedStrings(this.myGroupId, other.myGroupId, FoundArtifact::getPackagePriority);
        if (compare != 0) {
            return compare;
        }
        return this.myName.compareTo(other.myName);
    }

    private static int comparePrioritizedStrings(@NotNull String s1, @NotNull String s2, @NotNull Function<String, Integer> getPriority) {
        if (s1.equals(s2)) {
            return 0;
        }
        int relativePriority = getPriority.apply(s1) - getPriority.apply(s2);
        if (relativePriority == 0) {
            return s1.compareTo(s2);
        }
        return relativePriority;
    }

    private static int getPackagePriority(@NotNull String packageName) {
        if (packageName.startsWith("com.android")) {
            return 0;
        }
        if (packageName.startsWith("com.google")) {
            return 1;
        }
        return 2;
    }

    private static int getRepositoryPriority(@NotNull String repositoryName) {
        if (repositoryName.startsWith("Android Repository")) {
            return 0;
        }
        if (repositoryName.startsWith("Google Repository")) {
            return 1;
        }
        return 2;
    }

    @NotNull
    public List<String> getCoordinates() {
        String groupIdAndName = this.myGroupId + ":" + this.myName;
        return this.myVersions.stream().map(version -> groupIdAndName + ":" + version).collect(Collectors.toList());
    }

    public String toString() {
        return "{repository='" + this.myRepositoryName + '\'' + ", group='" + this.myGroupId + '\'' + ", name='" + this.myName + '\'' + ", versions=" + this.myVersions + '}';
    }
}

