/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class MavenCentralRepository
extends ArtifactRepository {
    @Override
    @NotNull
    public String getName() {
        return "Maven Central";
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request) throws Exception {
        String url = MavenCentralRepository.createRequestUrl(request);
        return (SearchResult)HttpRequests.request((String)url).accept("application/xml").connect(request1 -> {
            try {
                return this.parse(request1.getReader());
            }
            catch (JDOMException e) {
                String msg = String.format("Failed to parse request '%1$s'", request1);
                throw new IOException(msg, e);
            }
        });
    }

    @VisibleForTesting
    @NotNull
    static String createRequestUrl(@NotNull SearchRequest request) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("https://search.maven.org/solrsearch/select?").append("rows=").append(request.getRowCount()).append("&").append("start=").append(request.getStart()).append("&").append("wt=xml&").append("q=");
        String groupId = request.getGroupId();
        if (StringUtil.isNotEmpty((String)groupId)) {
            buffer.append("g:\"").append(groupId).append("\"+AND+");
        }
        buffer.append("a:\"").append(request.getArtifactName()).append("\"");
        return buffer.toString();
    }

    @VisibleForTesting
    @NotNull
    SearchResult parse(@NotNull Reader response) throws JDOMException, IOException {
        ArrayList artifacts = Lists.newArrayList();
        int totalFound = 0;
        Element root = JDOMUtil.load((Reader)response);
        Element result = root.getChild("result");
        if (result != null) {
            String found = result.getAttributeValue("numFound");
            if (StringUtil.isNotEmpty((String)found)) {
                try {
                    totalFound = Integer.parseInt(found);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            block2: for (Element doc : result.getChildren("doc")) {
                String id = null;
                GradleVersion latestVersion = null;
                for (Element str : doc.getChildren("str")) {
                    String value;
                    String name = str.getAttributeValue("name");
                    if ("id".equals(name)) {
                        id = str.getTextTrim();
                    } else if ("latestVersion".equals(name) && StringUtil.isNotEmpty((String)(value = str.getTextTrim()))) {
                        latestVersion = GradleVersion.parse((String)value);
                    }
                    if (!StringUtil.isNotEmpty((String)id) || latestVersion == null) continue;
                    List coordinate = Splitter.on((String)":").splitToList((CharSequence)id);
                    assert (coordinate.size() == 2);
                    artifacts.add(new FoundArtifact(this.getName(), (String)coordinate.get(0), (String)coordinate.get(1), latestVersion));
                    continue block2;
                }
            }
        }
        return new SearchResult(this.getName(), artifacts, totalFound);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 1;
    }
}

