/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchResult {
    @NotNull
    private final String myRepositoryName;
    @NotNull
    private final List<FoundArtifact> myArtifacts;
    @Nullable
    private final Exception myError;
    private final int myTotalFound;

    SearchResult(@NotNull String repositoryName, @NotNull Exception error) {
        this(repositoryName, Collections.emptyList(), error, 0);
    }

    SearchResult(@NotNull String repositoryName, @NotNull List<FoundArtifact> artifacts, int totalFound) {
        this(repositoryName, artifacts, null, totalFound);
    }

    private SearchResult(@NotNull String repositoryName, @NotNull List<FoundArtifact> artifacts, @Nullable Exception error, int totalFound) {
        this.myRepositoryName = repositoryName;
        this.myArtifacts = artifacts;
        this.myError = error;
        this.myTotalFound = totalFound;
    }

    @NotNull
    public List<FoundArtifact> getArtifacts() {
        return this.myArtifacts;
    }

    @Nullable
    public Exception getError() {
        return this.myError;
    }

    public int getTotalFound() {
        return this.myTotalFound;
    }

    @NotNull
    public List<String> getArtifactCoordinates() {
        ArrayList coordinates = Lists.newArrayList();
        this.myArtifacts.forEach(artifact -> coordinates.addAll(artifact.getCoordinates()));
        return coordinates;
    }

    public String toString() {
        return "{repository='" + this.myRepositoryName + '\'' + ", artifacts=" + this.myArtifacts + ", error=" + this.myError + ", totalFound=" + this.myTotalFound + '}';
    }
}

