/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.quickfix;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.google.common.base.Splitter;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class QuickFixes {
    public static final char QUICK_FIX_PATH_SEPARATOR = '/';
    @NonNls
    public static final String SET_LIBRARY_DEPENDENCY_QUICK_FIX = "setLibraryDependency";

    private QuickFixes() {
    }

    public static void executeQuickFix(@NotNull String quickFix, @NonNls PsContext context) {
        List segments = Splitter.on((char)'/').splitToList((CharSequence)quickFix);
        assert (!segments.isEmpty());
        String action = (String)segments.get(0);
        if (SET_LIBRARY_DEPENDENCY_QUICK_FIX.equals(action)) {
            assert (segments.size() == 4);
            String moduleName = (String)segments.get(1);
            String dependency = (String)segments.get(2);
            String version = (String)segments.get(3);
            QuickFixes.setLibraryDependencyVersion(context, moduleName, dependency, version);
        }
    }

    private static void setLibraryDependencyVersion(@NonNls PsContext context, @NotNull String moduleName, @NotNull String dependency, @NotNull String version) {
        PsModule module = context.getProject().findModuleByName(moduleName);
        if (module instanceof PsAndroidModule) {
            PsAndroidModule androidModule = (PsAndroidModule)module;
            androidModule.forEachDeclaredDependency(declaredDependency -> {
                if (declaredDependency instanceof PsLibraryDependency) {
                    QuickFixes.setLibraryDependencyVersion((PsLibraryDependency)((Object)declaredDependency), dependency, version);
                }
            });
        } else if (module instanceof PsJavaModule) {
            PsJavaModule javaModule = (PsJavaModule)module;
            javaModule.forEachDeclaredDependency(declaredDependency -> {
                if (declaredDependency instanceof PsLibraryDependency) {
                    QuickFixes.setLibraryDependencyVersion((PsLibraryDependency)((Object)declaredDependency), dependency, version);
                }
            });
        }
    }

    private static void setLibraryDependencyVersion(@NotNull PsLibraryDependency dependency, @NotNull String dependencySpec, @NotNull String version) {
        PsArtifactDependencySpec declaredSpec = dependency.getDeclaredSpec();
        if (declaredSpec != null && dependencySpec.equals(declaredSpec.compactNotation())) {
            dependency.setVersion(version);
        }
    }
}

