/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class BuildFileProcessor {
    @NotNull
    public static BuildFileProcessor getInstance() {
        return (BuildFileProcessor)ServiceManager.getService(BuildFileProcessor.class);
    }

    public void processRecursively(@NotNull Project project, @NotNull Processor<GradleBuildModel> processor) {
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile projectRootFolder = project.getBaseDir();
            if (projectRootFolder == null) {
                return;
            }
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)projectRootFolder, virtualFile -> {
                if ("build.gradle".equals(virtualFile.getName())) {
                    GradleBuildModel buildModel = GradleBuildModel.parseBuildFile(virtualFile, project);
                    return processor.process((Object)buildModel);
                }
                return true;
            });
        });
    }
}

