/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContentEntries {
    private ContentEntries() {
    }

    @Nullable
    public static ContentEntry findParentContentEntry(@NotNull File path, @NotNull Stream<ContentEntry> contentEntries) {
        Optional<ContentEntry> optional = contentEntries.filter(contentEntry -> ContentEntries.isPathInContentEntry(path, contentEntry)).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }

    public static boolean isPathInContentEntry(@NotNull File path, @NotNull ContentEntry contentEntry) {
        File rootFilePath;
        VirtualFile rootFile = contentEntry.getFile();
        if (rootFile == null) {
            String s = VfsUtilCore.urlToPath((String)contentEntry.getUrl());
            rootFilePath = new File(s);
        } else {
            rootFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)rootFile);
        }
        return FileUtil.isAncestor((File)rootFilePath, (File)path, (boolean)false);
    }
}

