/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.sdklib.AndroidVersion;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedDistributionPaths {
    @NotNull
    public static EmbeddedDistributionPaths getInstance() {
        return (EmbeddedDistributionPaths)ServiceManager.getService(EmbeddedDistributionPaths.class);
    }

    @NotNull
    public List<File> findAndroidStudioLocalMavenRepoPaths() {
        String relativePath;
        File repoPath;
        File defaultRootDirPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (defaultRootDirPath != null) {
            File repoPath2 = new File(defaultRootDirPath, "m2repository");
            return repoPath2.isDirectory() ? ImmutableList.of((Object)repoPath2) : ImmutableList.of();
        }
        ArrayList<File> repoPaths = new ArrayList<File>();
        String studioCustomRepo = System.getenv("STUDIO_CUSTOM_REPO");
        if (studioCustomRepo != null) {
            repoPath = new File(FileUtil.toCanonicalPath((String)FileUtil.toSystemDependentName((String)studioCustomRepo)));
            if (!repoPath.isDirectory()) {
                throw new IllegalArgumentException("Invalid path in STUDIO_CUSTOM_REPO environment variable");
            }
        } else {
            relativePath = FileUtil.toSystemDependentName((String)"/../../prebuilts/tools/common/offline-m2");
            repoPath = new File(FileUtil.toCanonicalPath((String)(EmbeddedDistributionPaths.getIdeHomePath() + relativePath)));
        }
        EmbeddedDistributionPaths.getLog().info("Looking for embedded Maven repo at '" + repoPath.getPath() + "'");
        if (repoPath.isDirectory()) {
            repoPaths.add(repoPath);
        }
        relativePath = FileUtil.toSystemDependentName((String)"/../../out/studio/repo");
        repoPath = new File(PathManager.getHomePath() + relativePath);
        if (repoPath.isDirectory()) {
            repoPaths.add(repoPath);
        }
        return repoPaths;
    }

    @NotNull
    public File findEmbeddedProfilerTransform(@NotNull AndroidVersion version) {
        File file = new File(PathManager.getHomePath(), "plugins/android/resources/profilers-transform.jar");
        if (file.exists()) {
            return file;
        }
        String relativePath = FileUtil.toSystemDependentName((String)"/../../bazel-genfiles/tools/base/profiler/transform/profilers-transform.jar");
        return new File(PathManager.getHomePath() + relativePath);
    }

    @Nullable
    public File findEmbeddedGradleDistributionPath() {
        File distributionPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (distributionPath != null) {
            Logger log = EmbeddedDistributionPaths.getLog();
            File embeddedPath = new File(distributionPath, "gradle-4.1");
            log.info("Looking for embedded Gradle distribution at '" + embeddedPath.getPath() + "'");
            if (embeddedPath.isDirectory()) {
                log.info("Found embedded Gradle 4.1");
                return embeddedPath;
            }
            log.info("Unable to find embedded Gradle 4.1");
            return null;
        }
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        String relativePath = FileUtil.toSystemDependentName((String)"/../../out/gradle-dist-link");
        distributionPath = new File(FileUtil.toCanonicalPath((String)(ideHomePath + relativePath)));
        return distributionPath.isDirectory() ? distributionPath : null;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(EmbeddedDistributionPaths.class);
    }

    @Nullable
    private static File getDefaultRootDirPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File rootDirPath = new File(ideHomePath, "gradle");
        return rootDirPath.isDirectory() ? rootDirPath : null;
    }

    @NotNull
    public File getEmbeddedJdkPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File jdkRootPath = new File(ideHomePath, SystemInfo.isMac ? FileUtil.join((String[])new String[]{"jre", "jdk"}) : "jre");
        if (jdkRootPath.isDirectory()) {
            return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
        }
        String jdkDevPath = System.getProperty("studio.dev.jdk", ideHomePath + "/../../prebuilts/studio/jdk");
        String relativePath = FileUtil.toSystemDependentName((String)jdkDevPath);
        jdkRootPath = new File(FileUtil.toCanonicalPath((String)relativePath));
        if (SystemInfo.isWindows) {
            jdkRootPath = new File(jdkRootPath, "win64");
        } else if (SystemInfo.isLinux) {
            jdkRootPath = new File(jdkRootPath, "linux");
        } else if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "mac");
        }
        return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
    }

    @NotNull
    private static File getSystemSpecificJdkPath(File jdkRootPath) {
        if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "/Contents/Home");
        }
        if (!jdkRootPath.isDirectory()) {
            throw new Error(String.format("Incomplete or corrupted installation - \"%s\" directory does not exist", jdkRootPath.toString()));
        }
        return jdkRootPath;
    }

    @NotNull
    private static String getIdeHomePath() {
        return FileUtil.toSystemDependentName((String)PathManager.getHomePath());
    }
}

