/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilePaths {
    private FilePaths() {
    }

    @NotNull
    public static String pathToIdeaUrl(@NotNull File path) {
        String name = path.getName();
        boolean isJarFile = FileUtil.extensionEquals((String)name, (String)"jar") || FileUtil.extensionEquals((String)name, (String)"zip");
        String protocol = isJarFile ? "jar" : "file";
        String url = VirtualFileManager.constructUrl((String)protocol, (String)FileUtil.toSystemIndependentName((String)path.getPath()));
        if (isJarFile) {
            url = url + "!/";
        }
        return url;
    }

    @Nullable
    public static File getJarFromJarUrl(@NotNull String url) {
        if (!url.startsWith("jar://")) {
            return null;
        }
        String path = url.substring("jar://".length());
        int index = path.lastIndexOf("!/");
        if (index != -1) {
            path = path.substring(0, index);
        }
        return FilePaths.toSystemDependentPath(path);
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static File toSystemDependentPath(@Nullable String path) {
        return path != null ? new File(FileUtilRt.toSystemDependentName((String)path)) : null;
    }

    @NotNull
    public static List<String> computeRootPathsForFiles(@NotNull Stream<String> filePaths) {
        ArrayList<String> folderPaths = new ArrayList<String>();
        filePaths.forEach(filePath -> {
            String parentPath = PathUtil.getParentPath((String)filePath);
            folderPaths.add(parentPath);
        });
        return FilePaths.mergePaths(folderPaths);
    }

    @NotNull
    public static List<String> mergePaths(@NotNull Collection<String> paths) {
        if (paths.isEmpty()) {
            return Collections.emptyList();
        }
        TreeSet<String> sortedPaths = new TreeSet<String>(paths);
        ArrayList<String> result = new ArrayList<String>(paths.size());
        String current = (String)sortedPaths.first();
        for (String folder : sortedPaths) {
            if (folder.startsWith(current)) continue;
            result.add(current);
            current = folder;
        }
        result.add(current);
        return result;
    }
}

