/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.level2.Library;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidProject;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependencies;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleUtil {
    public static final ProjectSystemId GRADLE_SYSTEM_ID = GradleConstants.SYSTEM_ID;
    @NonNls
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Logger LOG = Logger.getInstance(GradleUtil.class);
    private static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");

    private GradleUtil() {
    }

    public static void clearStoredGradleJvmArgs(@NotNull Project project) {
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        String existingJvmArgs = settings.getGradleVmOptions();
        settings.setGradleVmOptions(null);
        if (!StringUtil.isEmptyOrSpaces((String)existingJvmArgs)) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                String jvmArgs = existingJvmArgs.trim();
                String msg = String.format("Starting with version 1.3, Android Studio no longer supports IDE-specific Gradle JVM arguments.\n\nAndroid Studio will now remove any stored Gradle JVM arguments.\n\nWould you like to copy these JVM arguments:\n%1$s\nto the project's gradle.properties file?\n\n(Any existing JVM arguments in the gradle.properties file will be overwritten.)", jvmArgs);
                int result = Messages.showYesNoDialog((Project)project, (String)msg, (String)"Gradle Settings", (Icon)Messages.getQuestionIcon());
                if (result == 0) {
                    try {
                        GradleProperties gradleProperties = new GradleProperties(project);
                        gradleProperties.setJvmArgs(jvmArgs);
                        gradleProperties.save();
                    }
                    catch (IOException e) {
                        String err = String.format("Failed to copy JVM arguments '%1$s' to the project's gradle.properties file.", existingJvmArgs);
                        LOG.info(err, (Throwable)e);
                        String cause = e.getMessage();
                        if (StringUtil.isNotEmpty((String)cause)) {
                            err = err + String.format("<br>\nCause: %1$s", cause);
                        }
                        AndroidNotification.getInstance(project).showBalloon("Gradle Settings", err, NotificationType.ERROR);
                    }
                } else {
                    String text = String.format("JVM arguments<br>\n'%1$s'<br>\nwere not copied to the project's gradle.properties file.", existingJvmArgs);
                    AndroidNotification.getInstance(project).showBalloon("Gradle Settings", text, NotificationType.WARNING);
                }
            });
        }
    }

    public static boolean isSupportedGradleVersion(@NotNull GradleVersion gradleVersion) {
        GradleVersion supported = GradleVersion.parse((String)"4.1");
        return supported.compareTo(gradleVersion) <= 0;
    }

    @Deprecated
    @NotNull
    public static AndroidArtifactOutput getOutput(@NotNull AndroidArtifact artifact) {
        Collection outputs = artifact.getOutputs();
        assert (!outputs.isEmpty());
        AndroidArtifactOutput output = (AndroidArtifactOutput)ContainerUtil.getFirstItem((Collection)outputs);
        assert (output != null);
        return output;
    }

    @NotNull
    public static Icon getModuleIcon(@NotNull Module module) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel != null) {
            return GradleUtil.getAndroidModuleIcon(androidModel);
        }
        return AndroidProjectInfo.getInstance(module.getProject()).requiresAndroidModel() ? AllIcons.Nodes.PpJdk : StudioIcons.Shell.Filetree.ANDROID_MODULE;
    }

    @NotNull
    public static Icon getAndroidModuleIcon(@NotNull AndroidModuleModel androidModuleModel) {
        switch (androidModuleModel.getAndroidProject().getProjectType()) {
            case 0: {
                return StudioIcons.Shell.Filetree.ANDROID_MODULE;
            }
            case 5: {
                return StudioIcons.Shell.Filetree.FEATURE_MODULE;
            }
            case 4: {
                return StudioIcons.Shell.Filetree.INSTANT_APPS;
            }
            case 1: {
                return StudioIcons.Shell.Filetree.LIBRARY_MODULE;
            }
            case 2: {
                return StudioIcons.Shell.Filetree.ANDROID_TEST_ROOT;
            }
        }
        return StudioIcons.Shell.Filetree.ANDROID_MODULE;
    }

    @Nullable
    public static IdeAndroidProject getAndroidProject(@NotNull Module module) {
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        return gradleModel != null ? gradleModel.getAndroidProject() : null;
    }

    @Nullable
    public static NativeAndroidProject getNativeAndroidProject(@NotNull Module module) {
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
        return ndkModuleModel != null ? ndkModuleModel.getAndroidProject() : null;
    }

    @Nullable
    public static String getGradlePath(@NotNull Module module) {
        GradleFacet facet = GradleFacet.getInstance(module);
        return facet != null ? ((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    public static boolean isRootModuleWithNoSources(@NotNull Module module) {
        String gradlePath;
        return ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 0 && ((gradlePath = GradleUtil.getGradlePath(module)) == null || gradlePath.equals(":"));
    }

    @NotNull
    public static List<Library> getModuleDependencies(@NotNull IdeVariant variant) {
        ArrayList libraries = Lists.newArrayList();
        IdeAndroidArtifact mainArtifact = variant.getMainArtifact();
        IdeDependencies dependencies2 = mainArtifact.getLevel2Dependencies();
        libraries.addAll(dependencies2.getModuleDependencies());
        for (IdeBaseArtifact testArtifact : variant.getTestArtifacts()) {
            dependencies2 = testArtifact.getLevel2Dependencies();
            libraries.addAll(dependencies2.getModuleDependencies());
        }
        return libraries;
    }

    @Nullable
    public static Module findModuleByGradlePath(@NotNull Project project, @NotNull String gradlePath) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null || !gradlePath.equals(((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH)) continue;
            return module;
        }
        return null;
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        return Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)gradlePath);
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module) {
        GradleFacet gradleFacet = GradleFacet.getInstance(module);
        if (gradleFacet != null && gradleFacet.getGradleModuleModel() != null) {
            return gradleFacet.getGradleModuleModel().getBuildFile();
        }
        File moduleFilePath = new File(module.getModuleFilePath());
        File parentFile = moduleFilePath.getParentFile();
        return parentFile != null ? GradleUtil.getGradleBuildFile(parentFile) : null;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        File gradleBuildFilePath = GradleUtil.getGradleBuildFilePath(dirPath);
        return VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleBuildFilePath(@NotNull File dirPath) {
        return new File(dirPath, "build.gradle");
    }

    @Nullable
    public static VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        File gradleSettingsFilePath = GradleUtil.getGradleSettingsFilePath(dirPath);
        return VfsUtil.findFileByIoFile((File)gradleSettingsFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleSettingsFilePath(@NotNull File dirPath) {
        return new File(dirPath, "settings.gradle");
    }

    @Nullable
    public static GradleExecutionSettings getOrCreateGradleExecutionSettings(@NotNull Project project) {
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(project);
        if (IdeInfo.getInstance().isAndroidStudio() && executionSettings == null) {
            File gradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath();
            assert (gradlePath != null && gradlePath.isDirectory());
            executionSettings = new GradleExecutionSettings(gradlePath.getPath(), null, DistributionType.LOCAL, null, false);
            File jdkPath = IdeSdks.getInstance().getJdkPath();
            if (jdkPath != null) {
                executionSettings.setJavaHome(jdkPath.getPath());
            }
        }
        return executionSettings;
    }

    @Nullable
    public static GradleExecutionSettings getGradleExecutionSettings(@NotNull Project project) {
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            File baseDirPath = Projects.getBaseDirPath(project);
            String msg = String.format("Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'", project.getName(), baseDirPath.getPath());
            LOG.info(msg);
            return null;
        }
        try {
            GradleExecutionSettings settings = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)GRADLE_SYSTEM_ID);
            if (settings != null) {
                settings.setRemoteProcessIdleTtlInMs(-1L);
            }
            return settings;
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static GradleProjectSettings getGradleProjectSettings(@NotNull Project project) {
        return GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
    }

    @VisibleForTesting
    @Nullable
    static String getGradleInvocationJvmArg(@Nullable BuildMode buildMode) {
        if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
            return AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
        }
        return null;
    }

    public static void stopAllGradleDaemonsAndRestart() {
        DefaultGradleConnector.close();
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).restart(true);
        } else {
            application.restart();
        }
    }

    @NotNull
    public static String getDefaultPhysicalPathFromGradlePath(@NotNull String gradlePath) {
        List<String> segments = GradleUtil.getPathSegments(gradlePath);
        return FileUtil.join((String[])ArrayUtil.toStringArray(segments));
    }

    @NotNull
    public static File getModuleDefaultPath(@NotNull VirtualFile parentDir, @NotNull String gradlePath) {
        assert (!gradlePath.isEmpty());
        String relativePath = GradleUtil.getDefaultPhysicalPathFromGradlePath(gradlePath);
        return new File(VfsUtilCore.virtualToIoFile((VirtualFile)parentDir), relativePath);
    }

    public static int isValidGradlePath(@NotNull String gradlePath) {
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    public static boolean hasModule(@Nullable Project project, @NotNull String gradlePath) {
        if (project == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!gradlePath.equals(GradleUtil.getGradlePath(module))) continue;
            return true;
        }
        File location = GradleUtil.getModuleDefaultPath(project.getBaseDir(), gradlePath);
        if (location.isFile()) {
            return true;
        }
        if (location.isDirectory()) {
            File[] children = location.listFiles();
            return children == null || children.length > 0;
        }
        return false;
    }

    @Nullable
    public static GradleVersion getAndroidGradleModelVersionInUse(@NotNull Project project) {
        HashSet foundInLibraries = Sets.newHashSet();
        HashSet foundInApps = Sets.newHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            String modelVersion = androidProject.getModelVersion();
            if (androidModel.getAndroidProject().getProjectType() == 0) {
                foundInApps.add(modelVersion);
                continue;
            }
            foundInLibraries.add(modelVersion);
        }
        String found = null;
        if (foundInApps.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInApps);
        } else if (foundInApps.isEmpty() && foundInLibraries.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInLibraries);
        }
        return found != null ? GradleVersion.tryParse((String)found) : null;
    }

    @Nullable
    public static GradleVersion getAndroidGradleModelVersionInUse(@NotNull Module module) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            return GradleVersion.tryParse((String)androidProject.getModelVersion());
        }
        return null;
    }

    public static void attemptToUseEmbeddedGradle(@NotNull Project project) {
        GradleWrapper gradleWrapper;
        if (IdeInfo.getInstance().isAndroidStudio() && (gradleWrapper = GradleWrapper.find(project)) != null) {
            GradleProjectSettings gradleSettings;
            File embeddedGradlePath;
            String gradleVersion = null;
            try {
                Properties properties = gradleWrapper.getProperties();
                String url = properties.getProperty("distributionUrl");
                gradleVersion = GradleUtil.getGradleWrapperVersionOnlyIfComingForGradleDotOrg(url);
            }
            catch (IOException e) {
                LOG.warn("Failed to read file " + gradleWrapper.getPropertiesFilePath().getPath());
            }
            if (gradleVersion != null && GradleUtil.isCompatibleWithEmbeddedGradleVersion(gradleVersion) && !GradleLocalCache.getInstance().containsGradleWrapperVersion(gradleVersion, project) && (embeddedGradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath()) != null && (gradleSettings = GradleUtil.getGradleProjectSettings(project)) != null) {
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                gradleSettings.setGradleHome(embeddedGradlePath.getPath());
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static String getGradleWrapperVersionOnlyIfComingForGradleDotOrg(@Nullable String url) {
        String version;
        String expectedPrefix;
        String protocol;
        int foundIndex;
        if (url != null && (foundIndex = url.indexOf("://")) != -1 && ((protocol = url.substring(0, foundIndex)).equals("http") || protocol.equals("https")) && url.startsWith(expectedPrefix = protocol + "://services.gradle.org/distributions/gradle-") && (foundIndex = url.indexOf(45, expectedPrefix.length())) != -1 && StringUtil.isNotEmpty((String)(version = url.substring(expectedPrefix.length(), foundIndex)))) {
            return version;
        }
        return null;
    }

    private static boolean isCompatibleWithEmbeddedGradleVersion(@NotNull String gradleVersion) {
        return gradleVersion.equals("4.1") || gradleVersion.equals("4.1");
    }

    public static boolean dependsOn(AndroidModuleModel androidModel, String artifact) {
        IdeDependencies dependencies2 = androidModel.getSelectedMainCompileLevel2Dependencies();
        return GradleUtil.dependsOnAndroidLibrary(dependencies2, artifact);
    }

    public static boolean dependsOnJavaLibrary(AndroidModuleModel androidModel, String artifact) {
        IdeDependencies dependencies2 = androidModel.getSelectedMainCompileLevel2Dependencies();
        for (Library library : dependencies2.getJavaLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static GradleVersion getModuleDependencyVersion(AndroidModuleModel androidModel, String artifact) {
        IdeDependencies dependencies2 = androidModel.getSelectedMainCompileLevel2Dependencies();
        for (Library library : dependencies2.getAndroidLibraries()) {
            String version = GradleUtil.getDependencyVersion(library, artifact);
            if (version == null) continue;
            return GradleVersion.tryParse((String)version);
        }
        return null;
    }

    public static boolean dependsOnAndroidTest(AndroidModuleModel androidModel, String artifact) {
        IdeDependencies dependencies2 = androidModel.getSelectedAndroidTestCompileDependencies();
        if (dependencies2 == null) {
            return false;
        }
        return GradleUtil.dependsOnAndroidLibrary(dependencies2, artifact);
    }

    private static boolean dependsOnAndroidLibrary(IdeDependencies dependencies2, String artifact) {
        for (Library library : dependencies2.getAndroidLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOn(AndroidLibrary library, String artifact, boolean transitively) {
        return GradleUtil.getDependencyVersion(library, artifact, transitively) != null;
    }

    private static String getDependencyVersion(AndroidLibrary library, String artifact, boolean transitively) {
        MavenCoordinates resolvedCoordinates = library.getResolvedCoordinates();
        if (resolvedCoordinates != null && artifact.endsWith(resolvedCoordinates.getArtifactId()) && artifact.equals(resolvedCoordinates.getGroupId() + ':' + resolvedCoordinates.getArtifactId())) {
            return resolvedCoordinates.getVersion();
        }
        if (transitively) {
            for (AndroidLibrary dependency : library.getLibraryDependencies()) {
                String version = GradleUtil.getDependencyVersion(dependency, artifact, true);
                if (version == null) continue;
                return version;
            }
        }
        return null;
    }

    public static boolean dependsOn(Library library, String artifact) {
        return GradleUtil.getDependencyVersion(library, artifact) != null;
    }

    private static String getDependencyVersion(Library library, String artifact) {
        GradleCoordinate resolvedCoordinates = GradleCoordinate.parseCoordinateString((String)library.getArtifactAddress());
        if (resolvedCoordinates != null && artifact.equals(resolvedCoordinates.getGroupId() + ':' + resolvedCoordinates.getArtifactId())) {
            return resolvedCoordinates.getRevision();
        }
        return null;
    }

    public static boolean hasCause(@NotNull Throwable e, @NotNull Class<?> causeClass) {
        String causeClassName = causeClass.getName();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!causeClassName.equals(ex.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static File getGradleUserSettingsFile() {
        String homePath = SystemProperties.getUserHome();
        if (homePath == null) {
            return null;
        }
        return new File(homePath, FileUtil.join((String[])new String[]{".gradle", "gradle.properties"}));
    }

    public static void setBuildToolsVersion(@NotNull Project project, @NotNull String version) {
        ArrayList modelsToUpdate = Lists.newArrayList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModel android;
            GradleBuildModel buildModel;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || (buildModel = GradleBuildModel.get(module)) == null || (android = buildModel.android()) == null || version.equals(android.buildToolsVersion().value())) continue;
            android.setBuildToolsVersion(version);
            modelsToUpdate.add(buildModel);
        }
        if (!modelsToUpdate.isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                for (GradleBuildModel buildModel : modelsToUpdate) {
                    buildModel.applyChanges();
                }
            });
        }
    }

    @Nullable
    public static Library findLibrary(@NotNull File bundleDir, @NotNull IdeVariant variant) {
        IdeAndroidArtifact artifact = variant.getMainArtifact();
        IdeDependencies dependencies2 = artifact.getLevel2Dependencies();
        for (Library library : dependencies2.getAndroidLibraries()) {
            if (!FileUtil.filesEqual((File)bundleDir, (File)library.getFolder())) continue;
            return library;
        }
        return null;
    }

    @NotNull
    public static String mapConfigurationName(@NotNull String configuration, @Nullable GradleVersion pluginVersion, boolean preferApi) {
        return GradleUtil.mapConfigurationName(configuration, pluginVersion != null ? pluginVersion.toString() : null, preferApi);
    }

    @NotNull
    public static String mapConfigurationName(@NotNull String configuration, @Nullable String pluginVersion, boolean preferApi) {
        boolean compatibilityNames = pluginVersion != null && pluginVersion.matches("[012]\\..*");
        return GradleUtil.mapConfigurationName(configuration, compatibilityNames, preferApi);
    }

    @NotNull
    public static String mapConfigurationName(@NotNull String configuration, boolean useCompatibilityNames, boolean preferApi) {
        if (useCompatibilityNames) {
            return configuration;
        }
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "compile", preferApi ? "api" : "implementation");
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "provided", "compileOnly");
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "apk", "runtimeOnly");
        return configuration;
    }

    public static boolean useCompatibilityConfigurationNames(@NotNull Project project) {
        return GradleUtil.useCompatibilityConfigurationNames(GradleUtil.getAndroidGradleModelVersionInUse(project));
    }

    public static boolean useCompatibilityConfigurationNames(@Nullable GradleVersion gradleVersion) {
        return gradleVersion != null && gradleVersion.getMajor() < 3;
    }

    private static String replaceSuffixWithCase(String s, String suffix, String newSuffix) {
        if (SdkUtils.endsWithIgnoreCase((String)s, (String)suffix)) {
            int suffixBegin = s.length() - suffix.length();
            if (Character.isUpperCase(s.charAt(suffixBegin))) {
                return s.substring(0, suffixBegin) + Character.toUpperCase(newSuffix.charAt(0)) + newSuffix.substring(1);
            }
            if (suffixBegin == 0) {
                return newSuffix;
            }
            return s.substring(0, suffixBegin) + suffix;
        }
        return s;
    }
}

