/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp;

import com.android.tools.idea.model.MergedManifest;
import com.android.tools.lint.checks.AndroidPatternMatcher;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class InstantAppUrlFinder {
    @NotNull
    private final Collection<Element> myActivities;

    public InstantAppUrlFinder(@NotNull MergedManifest manifest) {
        this(manifest.getActivities());
    }

    InstantAppUrlFinder(@NotNull Collection<Element> activities) {
        this.myActivities = activities;
    }

    @NotNull
    public ImmutableCollection<String> getAllUrls() {
        TreeMultimap allUrls = TreeMultimap.create();
        for (Element activity : this.myActivities) {
            for (Node node = activity.getFirstChild(); node != null; node = node.getNextSibling()) {
                InstantAppIntentFilterWrapper wrapper = InstantAppIntentFilterWrapper.of(node);
                UrlData urlData = wrapper.getUrlData();
                if (!urlData.isValid()) continue;
                allUrls.put((Object)wrapper.getOrder(), (Object)urlData.getUrl());
            }
        }
        return ImmutableList.copyOf((Collection)allUrls.values());
    }

    @NotNull
    public String getDefaultUrl() {
        ImmutableCollection<String> urls = this.getAllUrls();
        if (!urls.isEmpty()) {
            return (String)urls.iterator().next();
        }
        return "";
    }

    public boolean matchesUrl(@NotNull String url) {
        for (Element activity : this.myActivities) {
            for (Node node = activity.getFirstChild(); node != null; node = node.getNextSibling()) {
                InstantAppIntentFilterWrapper wrapper = InstantAppIntentFilterWrapper.of(node);
                if (!wrapper.matchesUrl(url)) continue;
                return true;
            }
        }
        return false;
    }

    static class UrlData {
        @NotNull
        private final Collection<String> mySchemes = new HashSet<String>();
        @NotNull
        private final Collection<String> myHosts = new HashSet<String>();
        @NotNull
        private final Collection<String> myPaths = new HashSet<String>();
        @NotNull
        private final Collection<String> myPathPrefixes = new HashSet<String>();
        @NotNull
        private final Collection<String> myPathPatterns = new HashSet<String>();

        UrlData() {
        }

        void addFromStrings(@NotNull String scheme, @NotNull String host, @NotNull String path, @NotNull String pathPrefix, @NotNull String pathPattern) {
            UrlData.addTo(this.mySchemes, scheme);
            UrlData.addTo(this.myHosts, host);
            UrlData.addTo(this.myPaths, path);
            UrlData.addTo(this.myPathPrefixes, pathPrefix);
            UrlData.addTo(this.myPathPatterns, pathPattern);
        }

        void addFromNode(@NotNull Node node) {
            if (node.getNodeType() == 1 && "data".equals(node.getNodeName())) {
                Element element = (Element)node;
                UrlData.addTo(this.mySchemes, element.getAttributeNS("http://schemas.android.com/apk/res/android", "scheme"));
                UrlData.addTo(this.myHosts, element.getAttributeNS("http://schemas.android.com/apk/res/android", "host"));
                UrlData.addTo(this.myPaths, element.getAttributeNS("http://schemas.android.com/apk/res/android", "path"));
                UrlData.addTo(this.myPathPrefixes, element.getAttributeNS("http://schemas.android.com/apk/res/android", "pathPrefix"));
                UrlData.addTo(this.myPathPatterns, element.getAttributeNS("http://schemas.android.com/apk/res/android", "pathPattern"));
            }
        }

        private static void addTo(@NotNull Collection<String> collection, @Nullable String string) {
            if (StringUtil.isNotEmpty((String)string)) {
                collection.add(string);
            }
        }

        @NotNull
        static String convertPatternToExample(@NotNull String pattern) {
            return pattern.replace(".*", "example");
        }

        boolean isValid() {
            return !this.mySchemes.isEmpty() && !this.myHosts.isEmpty() && this.getEffectivePath().startsWith("/");
        }

        @NotNull
        private String getEffectivePath() {
            String path;
            String string = path = this.myPaths.isEmpty() ? "" : this.myPaths.iterator().next();
            if (StringUtil.isEmpty((String)path)) {
                String string2 = path = this.myPathPrefixes.isEmpty() ? "" : this.myPathPrefixes.iterator().next() + "/.*";
            }
            if (StringUtil.isEmpty((String)path)) {
                path = this.myPathPatterns.isEmpty() ? "" : this.myPathPatterns.iterator().next();
            }
            return StringUtil.isNotEmpty((String)path) ? path : "/";
        }

        @NotNull
        String getUrl() {
            if (!this.isValid()) {
                return "";
            }
            String scheme = this.mySchemes.iterator().next();
            String host = this.myHosts.iterator().next();
            return String.format("%s://%s%s", scheme, host, UrlData.convertPatternToExample(this.getEffectivePath()));
        }

        boolean matchesUrl(@NotNull String url) {
            if (!this.isValid()) {
                return false;
            }
            boolean schemeMatched = false;
            for (String scheme : this.mySchemes) {
                if (!url.startsWith(scheme + "://")) continue;
                url = url.replaceFirst(scheme + "://", "");
                schemeMatched = true;
                break;
            }
            if (!schemeMatched) {
                return false;
            }
            boolean hostMatched = false;
            for (String host : this.myHosts) {
                if (!url.startsWith(host)) continue;
                url = url.replaceFirst(host, "");
                hostMatched = true;
                break;
            }
            if (!hostMatched) {
                return false;
            }
            for (String path : this.myPaths) {
                if (!StringUtil.isNotEmpty((String)path) || !new AndroidPatternMatcher(path, 0).match(url)) continue;
                return true;
            }
            for (String pathPrefix : this.myPathPrefixes) {
                if (!StringUtil.isNotEmpty((String)pathPrefix) || !new AndroidPatternMatcher(pathPrefix, 1).match(url)) continue;
                return true;
            }
            for (String pathPattern : this.myPathPatterns) {
                if (!StringUtil.isNotEmpty((String)pathPattern) || !new AndroidPatternMatcher(pathPattern, 2).match(url)) continue;
                return true;
            }
            if (!(this.myPaths.isEmpty() && this.myPathPrefixes.isEmpty() && this.myPathPatterns.isEmpty())) {
                return false;
            }
            return url.isEmpty() || url.compareTo("/") == 0;
        }
    }

    static class InstantAppIntentFilterWrapper {
        @Nullable
        private final Element myElement;
        private final int myOrder;

        private InstantAppIntentFilterWrapper(@Nullable Element element, int order) {
            this.myElement = element;
            this.myOrder = order;
        }

        @NotNull
        static InstantAppIntentFilterWrapper of(@NotNull Node node) {
            int order;
            Element element;
            try {
                element = InstantAppIntentFilterWrapper.getElement(node);
                order = InstantAppIntentFilterWrapper.getOrder(element);
            }
            catch (IllegalArgumentException unused) {
                element = null;
                order = -1;
            }
            return new InstantAppIntentFilterWrapper(element, order);
        }

        @NotNull
        static Element getElement(@NotNull Node node) {
            if (node.getNodeType() == 1 && "intent-filter".equals(node.getNodeName())) {
                return (Element)node;
            }
            throw new IllegalArgumentException();
        }

        static int getOrder(@NotNull Element element) {
            String orderValue = element.getAttributeNS("http://schemas.android.com/apk/res/android", "order");
            if (StringUtil.isNotEmpty((String)orderValue)) {
                try {
                    return Integer.parseUnsignedInt(orderValue);
                }
                catch (NumberFormatException unused) {
                    throw new IllegalArgumentException();
                }
            }
            return 0;
        }

        @NotNull
        UrlData getUrlData() {
            UrlData urlData = new UrlData();
            if (this.myElement != null) {
                for (Node node = this.myElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                    urlData.addFromNode(node);
                }
            }
            return urlData;
        }

        int getOrder() {
            return this.myOrder;
        }

        boolean matchesUrl(@NotNull String url) {
            return this.getUrlData().matchesUrl(url);
        }
    }
}

