/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.instantapp.InstantAppSdks;
import com.android.tools.idea.instantapp.InstantAppUrlFinder;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantApps {
    @NotNull
    public static List<Module> findFeatureModules(@NotNull AndroidFacet facet) {
        return AndroidProjectInfo.getInstance(facet.getModule().getProject()).getAllModulesOfProjectType(5);
    }

    @Nullable
    public static Module findBaseFeature(@NotNull AndroidFacet facet) {
        return InstantApps.findBaseFeature(InstantApps.findFeatureModules(facet));
    }

    @Nullable
    public static Module findBaseFeature(@NotNull Project project) {
        return InstantApps.findBaseFeature(AndroidProjectInfo.getInstance(project).getAllModulesOfProjectType(5));
    }

    @Nullable
    public static String findMonolithicModuleName(@NotNull Project project) {
        List<Module> moduleList = AndroidProjectInfo.getInstance(project).getAllModulesOfProjectType(0);
        return moduleList.isEmpty() ? null : moduleList.get(0).getName();
    }

    @Nullable
    private static Module findBaseFeature(@NotNull List<Module> featureModules) {
        Module baseFeature = null;
        for (Module module : featureModules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null || !androidModel.getAndroidProject().isBaseSplit()) continue;
            baseFeature = module;
            break;
        }
        return baseFeature;
    }

    @NotNull
    public static String getDefaultInstantAppUrl(@NotNull AndroidFacet facet) {
        String defaultUrl = "<<ERROR - NO URL SET>>";
        List<Module> featureModules = InstantApps.findFeatureModules(facet);
        for (Module module : featureModules) {
            String foundUrl = new InstantAppUrlFinder(MergedManifest.get(module)).getDefaultUrl();
            if (!StringUtil.isNotEmpty((String)foundUrl)) continue;
            defaultUrl = foundUrl;
            break;
        }
        return defaultUrl;
    }

    public static boolean isInstantAppSdkEnabled() {
        return InstantAppSdks.getInstance().isInstantAppSdkEnabled();
    }

    @NotNull
    public static File getInstantAppSdk() throws FileNotFoundException {
        File sdk = InstantAppSdks.getInstance().getInstantAppSdk(true);
        if (sdk == null) {
            throw new FileNotFoundException("Instant App SDK couldn't be found.");
        }
        return sdk;
    }

    public static int getMinTargetSdk() {
        return InstantAppSdks.getInstance().getMinTargetSdk();
    }

    public static long getCompatApiMinVersion() {
        return InstantAppSdks.getInstance().getCompatApiMinVersion();
    }

    public static boolean isInstantAppApplicationModule(@NotNull Module module) {
        AndroidModuleModel model = AndroidModuleModel.get(module);
        return model != null && model.getAndroidProject().getProjectType() == 4;
    }

    public static boolean isPostO(IDevice device) {
        AndroidVersion version = device.getVersion();
        return version.compareTo(25, "O") >= 0;
    }
}

