/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp.provision;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.instantapp.provision.ProvisionException;
import com.android.instantapp.provision.ProvisionListener;
import com.android.instantapp.provision.ProvisionRunner;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.instantapp.provision.ProvisionEditTaskDialog;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import icons.AndroidIcons;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProvisionBeforeRunTaskProvider
extends BeforeRunTaskProvider<ProvisionBeforeRunTask> {
    @NotNull
    public static final Key<ProvisionBeforeRunTask> ID = Key.create((String)"com.android.instantApps.provision.BeforeRunTask");
    @NotNull
    private static final String TASK_NAME = "Instant App Provision";

    @NotNull
    public Key<ProvisionBeforeRunTask> getId() {
        return ID;
    }

    @NotNull
    public String getName() {
        return TASK_NAME;
    }

    @NotNull
    public String getDescription(ProvisionBeforeRunTask task) {
        return TASK_NAME;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @Nullable
    public Icon getTaskIcon(ProvisionBeforeRunTask task) {
        return AndroidIcons.Android;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public ProvisionBeforeRunTask createTask(RunConfiguration runConfiguration) {
        if (runConfiguration instanceof AndroidRunConfigurationBase && InstantApps.isInstantAppSdkEnabled()) {
            ProvisionBeforeRunTask task = new ProvisionBeforeRunTask();
            task.setEnabled(true);
            return task;
        }
        return null;
    }

    public boolean configureTask(RunConfiguration runConfiguration, ProvisionBeforeRunTask task) {
        ProvisionEditTaskDialog dialog = new ProvisionEditTaskDialog(runConfiguration.getProject(), task.isClearCache(), task.isClearProvisionedDevices());
        if (!dialog.showAndGet()) {
            return false;
        }
        task.setClearCache(dialog.isClearCache());
        task.setClearProvisionedDevices(dialog.isClearProvisionedDevices());
        return true;
    }

    public boolean canExecuteTask(RunConfiguration configuration, ProvisionBeforeRunTask task) {
        return this.isInstantAppContext((AndroidRunConfigurationBase)configuration);
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, final ProvisionBeforeRunTask task) {
        DeviceFutures deviceFutures;
        if (!this.isInstantAppContext((AndroidRunConfigurationBase)configuration)) {
            return true;
        }
        AndroidRunConfigContext runConfigContext = (AndroidRunConfigContext)env.getCopyableUserData(AndroidRunConfigContext.KEY);
        DeviceFutures deviceFutures2 = deviceFutures = runConfigContext == null ? null : runConfigContext.getTargetDevices();
        if (deviceFutures == null) {
            return false;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicBoolean result = new AtomicBoolean(true);
        progressManager.run((Task)new Task.Backgroundable(configuration.getProject(), this.getDescription(task), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(final @NotNull ProgressIndicator indicator) {
                AtomicBoolean tryAgain = new AtomicBoolean(true);
                try {
                    ProvisionRunner provisionRunner = new ProvisionRunner(InstantApps.getInstantAppSdk(), new ProvisionListener(){

                        public void printMessage(String message) {
                            indicator.setText2(message);
                        }

                        public void logMessage(String message, ProvisionException e) {
                            if (e == null) {
                                ProvisionBeforeRunTaskProvider.getLogger().info(message);
                            } else {
                                ProvisionBeforeRunTaskProvider.getLogger().warn(message, (Throwable)e);
                            }
                        }

                        public void setProgress(double fraction) {
                            indicator.setFraction(fraction);
                        }

                        public boolean isCancelled() {
                            return indicator.isCanceled();
                        }
                    });
                    indicator.setIndeterminate(true);
                    indicator.setText("Provisioning device");
                    if (task.isClearProvisionedDevices()) {
                        task.clearProvisionedDevices();
                    }
                    while (tryAgain.get()) {
                        try {
                            for (ListenableFuture<IDevice> deviceListenableFuture : deviceFutures.get()) {
                                IDevice device = ProvisionBeforeRunTaskProvider.waitForDevice((ListenableFuture<IDevice>)deviceListenableFuture, indicator);
                                if (device == null) {
                                    result.set(false);
                                    return;
                                }
                                if (task.isProvisioned(device)) continue;
                                indicator.setIndeterminate(false);
                                provisionRunner.runProvision(device);
                                if (task.isClearCache()) {
                                    try {
                                        device.executeShellCommand("pm clear com.google.android.instantapps.supervisor", NullOutputReceiver.getReceiver());
                                        device.executeShellCommand("pm clear com.google.android.instantapps.devman", NullOutputReceiver.getReceiver());
                                    }
                                    catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | com.android.ddmlib.TimeoutException | IOException e) {
                                        ProvisionBeforeRunTaskProvider.getLogger().warn("Error while clearing supervisor or devman cache on device", e);
                                    }
                                }
                                task.addProvisionedDevice(device);
                            }
                            tryAgain.set(false);
                        }
                        catch (ProvisionException e) {
                            ApplicationManager.getApplication().invokeAndWait(() -> {
                                int choice = Messages.showYesNoDialog((String)("Provision failed with message: " + e.getMessage() + ". Do you want to retry?"), (String)"Instant Apps", null);
                                if (choice == 0) {
                                    provisionRunner.clearCache();
                                } else {
                                    if (e.getErrorType() != ProvisionException.ErrorType.NO_GOOGLE_ACCOUNT && e.getErrorType() != ProvisionException.ErrorType.CANCELLED) {
                                        ProvisionBeforeRunTaskProvider.getLogger().error((Throwable)e);
                                    }
                                    tryAgain.set(false);
                                    result.set(false);
                                }
                            });
                        }
                    }
                    return;
                }
                catch (ProvisionException | FileNotFoundException e) {
                    ProvisionBeforeRunTaskProvider.getLogger().error("Error while provisioning devices", e);
                    result.set(false);
                    return;
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        });
        try {
            return countDownLatch.await(deviceFutures.get().size() * 300, TimeUnit.SECONDS) && result.get();
        }
        catch (InterruptedException e) {
            ProvisionBeforeRunTaskProvider.getLogger().error("Background thread interrupted", (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    boolean isInstantAppContext(@NotNull AndroidRunConfigurationBase runConfiguration) {
        Module module = ((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getModule();
        return InstantApps.isInstantAppSdkEnabled() && module != null && InstantApps.isInstantAppApplicationModule(module);
    }

    @Nullable
    private static IDevice waitForDevice(@NotNull ListenableFuture<IDevice> deviceFuture, @NotNull ProgressIndicator indicator) {
        while (true) {
            try {
                return (IDevice)deviceFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                return null;
            }
            catch (TimeoutException timeoutException) {
                if (!indicator.isCanceled()) continue;
                return null;
            }
            break;
        }
    }

    private static Logger getLogger() {
        return Logger.getInstance(ProvisionBeforeRunTaskProvider.class);
    }

    public static class ProvisionBeforeRunTask
    extends BeforeRunTask<ProvisionBeforeRunTask> {
        private static final ImmutableList<String> INSTANT_APP_PACKAGES = ImmutableList.of((Object)"com.google.android.instantapps.supervisor", (Object)"com.google.android.instantapps.devman");
        private boolean myClearCache = false;
        private boolean myClearProvisionedDevices = false;
        private long myTimestamp = 0L;
        @NotNull
        private final Set<String> myProvisionedDevices = new HashSet<String>();

        public ProvisionBeforeRunTask() {
            super(ID);
        }

        @VisibleForTesting
        void setClearCache(boolean clearCache) {
            this.myClearCache = clearCache;
        }

        @VisibleForTesting
        boolean isClearCache() {
            return this.myClearCache;
        }

        @VisibleForTesting
        void setClearProvisionedDevices(boolean clearProvisionedDevices) {
            this.myClearProvisionedDevices = clearProvisionedDevices;
        }

        @VisibleForTesting
        boolean isClearProvisionedDevices() {
            return this.myClearProvisionedDevices;
        }

        private void addProvisionedDevice(@NotNull String deviceSerial) {
            this.myProvisionedDevices.add(deviceSerial);
        }

        @VisibleForTesting
        void addProvisionedDevice(@NotNull IDevice device) {
            this.addProvisionedDevice(ProvisionBeforeRunTask.getHash(device));
        }

        @VisibleForTesting
        boolean isProvisioned(@NotNull IDevice device) {
            if (!this.myProvisionedDevices.contains(ProvisionBeforeRunTask.getHash(device))) {
                return false;
            }
            for (String pkgName : INSTANT_APP_PACKAGES) {
                if (this.isPackageInstalled(device, pkgName)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        private static String getHash(@NotNull IDevice device) {
            if (device.getAvdName() != null) {
                return device.getSerialNumber() + device.getAvdName();
            }
            return device.getSerialNumber();
        }

        @VisibleForTesting
        boolean isPackageInstalled(IDevice device, String pkgName) {
            CountDownLatch latch = new CountDownLatch(1);
            CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
            try {
                device.executeShellCommand("pm path " + pkgName, (IShellOutputReceiver)receiver);
                if (!latch.await(500L, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return !receiver.getOutput().isEmpty();
        }

        private void clearProvisionedDevices() {
            this.myProvisionedDevices.clear();
        }

        @VisibleForTesting
        long getTimestamp() {
            return this.myTimestamp;
        }

        public void writeExternal(Element element) {
            super.writeExternal(element);
            element.setAttribute("clearCache", String.valueOf(this.myClearCache));
            element.setAttribute("clearProvisionedDevices", String.valueOf(this.myClearProvisionedDevices));
            for (String deviceId : this.myProvisionedDevices) {
                element.addContent(new Element("provisionedDevices").setAttribute("provisionedDevice", deviceId));
            }
            element.setAttribute("myTimestamp", Long.toString(System.currentTimeMillis()));
        }

        public void readExternal(Element element) {
            super.readExternal(element);
            this.myClearCache = Boolean.valueOf(element.getAttributeValue("clearCache"));
            this.myClearProvisionedDevices = Boolean.valueOf(element.getAttributeValue("clearProvisionedDevices"));
            List children = element.getChildren("provisionedDevices");
            for (Element child : children) {
                this.addProvisionedDevice(child.getAttributeValue("provisionedDevice"));
            }
            try {
                this.myTimestamp = Long.parseLong(element.getAttributeValue("myTimestamp"));
            }
            catch (NumberFormatException e) {
                this.myTimestamp = 0L;
            }
            long timeDiff = System.currentTimeMillis() - this.myTimestamp;
            if (this.myTimestamp != 0L && (timeDiff < 0L || timeDiff > 3600000L)) {
                this.clearProvisionedDevices();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ProvisionBeforeRunTask that = (ProvisionBeforeRunTask)((Object)o);
            return this.myClearCache == that.myClearCache && this.myClearProvisionedDevices == that.myClearProvisionedDevices && this.myTimestamp == that.myTimestamp && Objects.equals(this.myProvisionedDevices, that.myProvisionedDevices);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myClearCache, this.myClearProvisionedDevices, this.myTimestamp, this.myProvisionedDevices);
        }
    }
}

