/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.rs;

import com.android.tools.idea.lang.rs.RenderscriptLexer;
import com.android.tools.idea.lang.rs.RenderscriptTokenType;
import com.google.common.collect.Maps;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RenderscriptSyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> sAttributes = Maps.newHashMapWithExpectedSize((int)20);
    private static final TokenSet ourKeywords = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.KEYWORD});
    private static final TokenSet ourBraces = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.BRACE});
    private static final TokenSet ourSeparators = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.SEPARATOR});
    private static final TokenSet ourOperators = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.OPERATOR});
    private static final TokenSet ourComments = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.COMMENT});
    private static final TokenSet ourString = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.STRING});
    private static final TokenSet ourCharacter = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.CHARACTER, RenderscriptTokenType.NUMBER});
    private static final TokenSet ourError = TokenSet.create((IElementType[])new IElementType[]{RenderscriptTokenType.UNKNOWN});

    @NotNull
    public Lexer getHighlightingLexer() {
        return new RenderscriptLexer();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        return RenderscriptSyntaxHighlighter.pack((TextAttributesKey)sAttributes.get(tokenType));
    }

    static {
        RenderscriptSyntaxHighlighter.fillMap(sAttributes, (TokenSet)ourKeywords, (TextAttributesKey)JavaHighlightingColors.KEYWORD);
        RenderscriptSyntaxHighlighter.fillMap(sAttributes, (TokenSet)ourBraces, (TextAttributesKey)JavaHighlightingColors.BRACES);
        RenderscriptSyntaxHighlighter.fillMap(sAttributes, (TokenSet)ourSeparators, (TextAttributesKey)JavaHighlightingColors.JAVA_SEMICOLON);
        RenderscriptSyntaxHighlighter.fillMap(sAttributes, (TokenSet)ourOperators, (TextAttributesKey)JavaHighlightingColors.OPERATION_SIGN);
        RenderscriptSyntaxHighlighter.fillMap(sAttributes, (TokenSet)ourComments, (TextAttributesKey)JavaHighlightingColors.JAVA_BLOCK_COMMENT);
        RenderscriptSyntaxHighlighter.fillMap(sAttributes, (TokenSet)ourString, (TextAttributesKey)JavaHighlightingColors.STRING);
        RenderscriptSyntaxHighlighter.fillMap(sAttributes, (TokenSet)ourCharacter, (TextAttributesKey)JavaHighlightingColors.NUMBER);
        RenderscriptSyntaxHighlighter.fillMap(sAttributes, (TokenSet)ourError, (TextAttributesKey)CodeInsightColors.ERRORS_ATTRIBUTES);
    }
}

