/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.resources.ResourceUrl;
import com.android.tools.idea.lint.GenerateBackupDescriptorFix;
import com.android.tools.idea.lint.SetAndGenerateBackupDescriptor;
import com.android.tools.lint.checks.ManifestDetector;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintAllowBackupInspection
extends AndroidLintInspectionBase {
    public AndroidLintAllowBackupInspection() {
        super(AndroidBundle.message("android.lint.inspections.allow.backup", new Object[0]), ManifestDetector.ALLOW_BACKUP);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        ResourceUrl url;
        if ("Missing `<full-backup-content>` resource".equals(message) && (url = ResourceUrl.parse((String)startElement.getText())) != null) {
            return new AndroidLintQuickFix[]{new GenerateBackupDescriptorFix(url)};
        }
        return new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set backup attribute", "allowBackup", null), new SetAttributeQuickFix("Set fullBackupContent attribute", "fullBackupContent", null){

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                return SetAndGenerateBackupDescriptor.isAllowBackupEnabled(startElement) && super.isApplicable(startElement, endElement, contextType);
            }
        }, new SetAndGenerateBackupDescriptor()};
    }
}

