/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.lint.AddTargetApiQuickFix;
import com.android.tools.idea.lint.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLintApiInspection
extends AndroidLintInspectionBase {
    public AndroidLintApiInspection(String displayName, Issue issue2) {
        super(displayName, issue2);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        Integer apiLevel = (Integer)LintFix.getData((LintFix)fixData, Integer.class);
        if (apiLevel != null) {
            int api = apiLevel;
            ArrayList list = Lists.newArrayList();
            PsiFile file = startElement.getContainingFile();
            boolean isXml = false;
            if (file instanceof XmlFile) {
                FolderConfiguration config;
                isXml = true;
                ResourceFolderType folderType = ResourceHelper.getFolderType(file);
                if (folderType != null && (config = ResourceHelper.getFolderConfiguration(file)) != null) {
                    config.setVersionQualifier(new VersionQualifier(api));
                    String folder = config.getFolderName(folderType);
                    list.add(OverrideResourceAction.createFix(folder));
                }
            }
            list.add(new AddTargetVersionCheckQuickFix(api));
            list.add(new AddTargetApiQuickFix(api, false, startElement));
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Project project = startElement.getProject();
            if (!isXml && JavaPsiFacade.getInstance((Project)project).findClass("android.support.annotation.RequiresApi", GlobalSearchScope.allScope((Project)project)) != null) {
                list.add(new AddTargetApiQuickFix(api, true, startElement));
            }
            return list.toArray(new AndroidLintQuickFix[list.size()]);
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }
}

