/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.lint.checks.ByteOrderMarkDetector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintByteOrderMarkInspection
extends AndroidLintInspectionBase {
    public AndroidLintByteOrderMarkInspection() {
        super(AndroidBundle.message("android.lint.inspections.byte.order.mark", new Object[0]), ByteOrderMarkDetector.BOM);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        return new AndroidLintQuickFix[]{new DefaultLintQuickFix("Remove byte order marks"){

            @Override
            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                Document document = FileDocumentManager.getInstance().getDocument(startElement.getContainingFile().getVirtualFile());
                if (document != null) {
                    String text = document.getText();
                    for (int i = text.length() - 1; i >= 0; --i) {
                        char c = text.charAt(i);
                        if (c != '\ufeff') continue;
                        document.deleteString(i, i + 1);
                    }
                }
            }
        }};
    }
}

